/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public abstract class AbstractWidthReadHandler
implements CSSValueReadHandler {
    private boolean allowPercentages;
    private boolean allowAuto;

    protected AbstractWidthReadHandler(boolean allowPercentages, boolean allowAuto) {
        this.allowPercentages = allowPercentages;
        this.allowAuto = allowAuto;
    }

    public boolean isAllowPercentages() {
        return this.allowPercentages;
    }

    public boolean isAllowAuto() {
        return this.allowAuto;
    }

    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        return this.parseWidth(value);
    }

    protected CSSValue parseWidth(LexicalUnit value) {
        if (this.allowPercentages && value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        if (this.allowAuto && value.getLexicalUnitType() == 35) {
            if (value.getStringValue().equalsIgnoreCase("auto")) {
                return CSSAutoValue.getInstance();
            }
            return null;
        }
        return CSSValueFactory.createLengthValue(value);
    }
}

