/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler;

import java.util.HashMap;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public abstract class OneOfConstantsReadHandler
implements CSSValueReadHandler {
    private HashMap constants = new HashMap();
    private boolean autoAllowed;

    protected OneOfConstantsReadHandler(boolean auto) {
        this.autoAllowed = auto;
        if (this.autoAllowed) {
            this.constants.put("auto", CSSAutoValue.getInstance());
        }
    }

    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        return this.lookupValue(value);
    }

    protected CSSValue lookupValue(LexicalUnit value) {
        if (value.getLexicalUnitType() != 35) {
            return null;
        }
        return (CSSValue)this.constants.get(value.getStringValue().toLowerCase());
    }

    protected void addValue(CSSConstant constant) {
        this.constants.put(constant.getCSSText().toLowerCase(), constant);
    }

    public boolean isAutoAllowed() {
        return this.autoAllowed;
    }
}

