/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.ArrayList;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.ListOfPairReadHandler;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BackgroundPositionReadHandler
extends ListOfPairReadHandler {
    public static final CSSNumericValue CENTER = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 50.0);
    public static final CSSNumericValue TOP = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue LEFT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue BOTTOM = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);
    public static final CSSNumericValue RIGHT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);

    protected CSSValue parseFirstPosition(LexicalUnit value) {
        if (value == null) {
            return null;
        }
        if (value.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(value.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(value.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(value.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(value.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(value.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(value)) {
            return CSSValueFactory.createLengthValue(value);
        }
        return null;
    }

    protected void addToResultList(ArrayList values, CSSValue firstPosition, CSSValue secondPosition) {
        if (firstPosition == TOP || firstPosition == BOTTOM) {
            super.addToResultList(values, secondPosition, firstPosition);
        } else if (secondPosition == LEFT || secondPosition == RIGHT) {
            super.addToResultList(values, secondPosition, firstPosition);
        } else {
            super.addToResultList(values, firstPosition, secondPosition);
        }
    }

    protected CSSValue parseSecondPosition(LexicalUnit value, CSSValue firstValue) {
        if (value == null) {
            return CENTER;
        }
        if (value.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(value.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(value.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(value.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(value.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(value.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(value)) {
            return CSSValueFactory.createLengthValue(value);
        }
        return CENTER;
    }
}

