/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.color.ColorReadHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BorderColorReadHandler
implements CSSValueReadHandler,
CSSCompoundValueReadHandler {
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        return ColorReadHandler.createColorValue(value);
    }

    public Map createValues(LexicalUnit unit) {
        CSSValue leftColor;
        CSSValue bottomColor;
        CSSValue rightColor;
        CSSValue topColor = ColorReadHandler.createColorValue(unit);
        if (topColor == null) {
            return null;
        }
        if ((unit = unit.getNextLexicalUnit()) == null) {
            rightColor = topColor;
        } else {
            rightColor = ColorReadHandler.createColorValue(unit);
            if (rightColor == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            bottomColor = topColor;
        } else {
            bottomColor = ColorReadHandler.createColorValue(unit);
            if (bottomColor == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            leftColor = rightColor;
        } else {
            leftColor = ColorReadHandler.createColorValue(unit);
            if (leftColor == null) {
                return null;
            }
        }
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(BorderStyleKeys.BORDER_TOP_COLOR, topColor);
        map.put(BorderStyleKeys.BORDER_RIGHT_COLOR, rightColor);
        map.put(BorderStyleKeys.BORDER_BOTTOM_COLOR, bottomColor);
        map.put(BorderStyleKeys.BORDER_LEFT_COLOR, leftColor);
        return map;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_COLOR, BorderStyleKeys.BORDER_RIGHT_COLOR, BorderStyleKeys.BORDER_BOTTOM_COLOR, BorderStyleKeys.BORDER_LEFT_COLOR};
    }
}

