/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class BorderRadiusReadHandler
implements CSSValueReadHandler,
CSSCompoundValueReadHandler {
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        CSSNumericValue secondValue;
        CSSNumericValue firstValue = CSSValueFactory.createLengthValue(value);
        if (firstValue == null) {
            return null;
        }
        if ((value = value.getNextLexicalUnit()) == null) {
            secondValue = firstValue;
        } else {
            secondValue = CSSValueFactory.createLengthValue(value);
            if (secondValue == null) {
                return null;
            }
        }
        return new CSSValuePair(firstValue, secondValue);
    }

    public Map createValues(LexicalUnit unit) {
        CSSValue value = this.createValue(null, unit);
        if (value == null) {
            return null;
        }
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(BorderStyleKeys.BORDER_TOP_RIGHT_RADIUS, value);
        map.put(BorderStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS, value);
        map.put(BorderStyleKeys.BORDER_BOTTOM_LEFT_RADIUS, value);
        map.put(BorderStyleKeys.BORDER_TOP_LEFT_RADIUS, value);
        return map;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_RIGHT_RADIUS, BorderStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS, BorderStyleKeys.BORDER_BOTTOM_LEFT_RADIUS, BorderStyleKeys.BORDER_TOP_LEFT_RADIUS};
    }
}

