/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.border.BorderStyleReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.color.ColorReadHandler;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BorderReadHandler
extends BorderStyleReadHandler
implements CSSCompoundValueReadHandler {
    public Map createValues(LexicalUnit unit) {
        CSSConstant style;
        CSSNumericValue width = CSSValueFactory.createLengthValue(unit);
        if (width != null) {
            unit = unit.getNextLexicalUnit();
        }
        if (unit != null) {
            style = (CSSConstant)this.lookupValue(unit);
            if (style != null) {
                unit = unit.getNextLexicalUnit();
            }
        } else {
            style = null;
        }
        CSSValue color = unit != null ? ColorReadHandler.createColorValue(unit) : null;
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        if (width != null) {
            map.put(BorderStyleKeys.BORDER_TOP_WIDTH, width);
            map.put(BorderStyleKeys.BORDER_LEFT_WIDTH, width);
            map.put(BorderStyleKeys.BORDER_BOTTOM_WIDTH, width);
            map.put(BorderStyleKeys.BORDER_RIGHT_WIDTH, width);
        }
        if (style != null) {
            map.put(BorderStyleKeys.BORDER_TOP_STYLE, style);
            map.put(BorderStyleKeys.BORDER_LEFT_STYLE, style);
            map.put(BorderStyleKeys.BORDER_BOTTOM_STYLE, style);
            map.put(BorderStyleKeys.BORDER_RIGHT_STYLE, style);
        }
        if (color != null) {
            map.put(BorderStyleKeys.BORDER_TOP_COLOR, color);
            map.put(BorderStyleKeys.BORDER_LEFT_COLOR, color);
            map.put(BorderStyleKeys.BORDER_BOTTOM_COLOR, color);
            map.put(BorderStyleKeys.BORDER_RIGHT_COLOR, color);
        }
        return map;
    }
}

