/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.box;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSRectangleType;
import org.jfree.layouting.input.style.values.CSSRectangleValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class OverflowClipReadHandler
implements CSSValueReadHandler {
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        if (value.getLexicalUnitType() == 35) {
            String stringValue = value.getStringValue();
            if (stringValue.equalsIgnoreCase("auto")) {
                return CSSAutoValue.getInstance();
            }
        } else {
            if (value.getLexicalUnitType() == 41) {
                if (value.getFunctionName().equalsIgnoreCase("inset-rect")) {
                    return OverflowClipReadHandler.getRectangle(CSSRectangleType.INSET_RECT, value.getParameters());
                }
                return null;
            }
            if (value.getLexicalUnitType() == 38) {
                return OverflowClipReadHandler.getRectangle(CSSRectangleType.RECT, value.getParameters());
            }
        }
        return null;
    }

    private static CSSRectangleValue getRectangle(CSSRectangleType type, LexicalUnit value) {
        CSSNumericValue[] list = new CSSNumericValue[4];
        for (int index = 0; index < 4; ++index) {
            if (value == null) {
                return null;
            }
            CSSNumericValue nval = CSSValueFactory.createLengthValue(value);
            if (nval != null) {
                list[index] = nval;
            } else if (value.getLexicalUnitType() == 23) {
                list[index] = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
            } else {
                return null;
            }
            value = CSSValueFactory.parseComma(value);
        }
        return new CSSRectangleValue(type, list[0], list[1], list[2], list[3]);
    }
}

