/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.line;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.line.AlignmentBaseline;
import org.jfree.layouting.input.style.keys.line.BaselineShift;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class VerticalAlignReadHandler
extends OneOfConstantsReadHandler
implements CSSCompoundValueReadHandler {
    public VerticalAlignReadHandler() {
        super(true);
        this.addValue(VerticalAlign.BASELINE);
        this.addValue(VerticalAlign.BOTTOM);
        this.addValue(VerticalAlign.CENTRAL);
        this.addValue(VerticalAlign.MIDDLE);
        this.addValue(VerticalAlign.SUB);
        this.addValue(VerticalAlign.SUPER);
        this.addValue(VerticalAlign.TEXT_BOTTOM);
        this.addValue(VerticalAlign.TEXT_TOP);
        this.addValue(VerticalAlign.USE_SCRIPT);
        this.addValue(VerticalAlign.TOP);
    }

    protected CSSValue lookupValue(LexicalUnit value) {
        CSSValue constant = super.lookupValue(value);
        if (constant != null) {
            return constant;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        return CSSValueFactory.createLengthValue(value);
    }

    public Map createValues(LexicalUnit unit) {
        CSSValue value = this.lookupValue(unit);
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(LineStyleKeys.VERTICAL_ALIGN, value);
        map.put(LineStyleKeys.ALIGNMENT_ADJUST, CSSAutoValue.getInstance());
        map.put(LineStyleKeys.DOMINANT_BASELINE, CSSAutoValue.getInstance());
        if (CSSAutoValue.getInstance().equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BASELINE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.BASELINE.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.BOTTOM.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.AFTER_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.CENTRAL.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.CENTRAL);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.MIDDLE.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.MIDDLE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.SUB.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.SUB);
        } else if (VerticalAlign.SUPER.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.SUPER);
        } else if (VerticalAlign.TEXT_BOTTOM.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.TEXT_AFTER_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.TEXT_TOP.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.TEXT_BEFORE_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.TOP.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BEFORE_EDGE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.USE_SCRIPT.equals(value)) {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            map.put(LineStyleKeys.BASELINE_SHIFT, CSSAutoValue.getInstance());
        } else {
            map.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BASELINE);
            map.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
            map.put(LineStyleKeys.ALIGNMENT_ADJUST, value);
        }
        return map;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{LineStyleKeys.VERTICAL_ALIGN, LineStyleKeys.ALIGNMENT_BASELINE, LineStyleKeys.DOMINANT_BASELINE, LineStyleKeys.ALIGNMENT_ADJUST, LineStyleKeys.BASELINE_SHIFT};
    }
}

