/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.page;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageSizeFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.AbstractWidthReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class SizeReadHandler
extends AbstractWidthReadHandler
implements CSSValueReadHandler {
    public SizeReadHandler() {
        super(true, false);
    }

    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        CSSNumericValue verticalWidth;
        if (value.getLexicalUnitType() == 35) {
            String ident = value.getStringValue();
            if (ident.equalsIgnoreCase("auto")) {
                return CSSAutoValue.getInstance();
            }
            PageSize ps = PageSizeFactory.getInstance().getPageSizeByName(ident);
            if (ps == null) {
                return null;
            }
            value = value.getNextLexicalUnit();
            int pageOrientation = 1;
            if (value != null) {
                if (value.getLexicalUnitType() != 35) {
                    return null;
                }
                if (value.getStringValue().equalsIgnoreCase("landscape")) {
                    pageOrientation = 0;
                } else if (value.getStringValue().equalsIgnoreCase("reverse-landscape")) {
                    pageOrientation = 2;
                } else if (value.getStringValue().equalsIgnoreCase("portrait")) {
                    pageOrientation = 1;
                } else {
                    return null;
                }
            }
            if (pageOrientation == 0 || pageOrientation == 2) {
                return new CSSValuePair(CSSNumericValue.createPtValue(ps.getHeight()), CSSNumericValue.createPtValue(ps.getWidth()));
            }
            return new CSSValuePair(CSSNumericValue.createPtValue(ps.getWidth()), CSSNumericValue.createPtValue(ps.getHeight()));
        }
        CSSNumericValue horizontalWidth = (CSSNumericValue)this.parseWidth(value);
        if (horizontalWidth == null) {
            return null;
        }
        if ((value = value.getNextLexicalUnit()) == null) {
            verticalWidth = horizontalWidth;
        } else {
            verticalWidth = (CSSNumericValue)this.parseWidth(value);
            if (verticalWidth == null) {
                return null;
            }
        }
        return new CSSValuePair(horizontalWidth, verticalWidth);
    }
}

