/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.text;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.text.TextOverflowEllipsisReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.text.TextOverflowModeReadHandler;
import org.jfree.layouting.input.style.values.CSSInheritValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class TextOverflowReadHandler
implements CSSCompoundValueReadHandler {
    private TextOverflowModeReadHandler modeReadHandler = new TextOverflowModeReadHandler();
    private TextOverflowEllipsisReadHandler ellipsisReadHandler = new TextOverflowEllipsisReadHandler();

    public Map createValues(LexicalUnit unit) {
        if (unit.getLexicalUnitType() == 12) {
            HashMap<StyleKey, CSSInheritValue> map = new HashMap<StyleKey, CSSInheritValue>();
            map.put(TextStyleKeys.TEXT_OVERFLOW_MODE, CSSInheritValue.getInstance());
            map.put(TextStyleKeys.TEXT_OVERFLOW_ELLIPSIS, CSSInheritValue.getInstance());
            return map;
        }
        CSSValue mode = this.modeReadHandler.createValue(null, unit);
        if (mode != null) {
            unit = unit.getNextLexicalUnit();
        }
        CSSValue ellipsis = unit != null ? this.ellipsisReadHandler.createValue(null, unit) : null;
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        if (mode != null) {
            map.put(TextStyleKeys.TEXT_OVERFLOW_MODE, mode);
        }
        if (ellipsis != null) {
            map.put(TextStyleKeys.TEXT_OVERFLOW_ELLIPSIS, ellipsis);
        }
        return map;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{TextStyleKeys.TEXT_OVERFLOW_MODE, TextStyleKeys.TEXT_OVERFLOW_ELLIPSIS};
    }
}

