/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.values;

import org.jfree.layouting.input.style.values.CSSValue;

public class CSSFunctionValue
implements CSSValue {
    private String functionName;
    private CSSValue[] parameters;

    public CSSFunctionValue(String functionName, CSSValue[] parameters) {
        if (functionName == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.functionName = functionName;
        this.parameters = (CSSValue[])parameters.clone();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public CSSValue[] getParameters() {
        return (CSSValue[])this.parameters.clone();
    }

    public String getCSSText() {
        StringBuffer b = new StringBuffer();
        b.append(this.functionName);
        b.append("(");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            CSSValue parameter = this.parameters[i];
            b.append(parameter.getCSSText());
        }
        b.append(")");
        return b.toString();
    }

    public String toString() {
        return this.getCSSText();
    }
}

