/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.values;

import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSValue;

public class CSSNumericValue
implements CSSValue {
    public static final CSSNumericValue ZERO_LENGTH = CSSNumericValue.createValue(CSSNumericType.PT, 0.0);
    private double value;
    private CSSNumericType type;

    protected CSSNumericValue(CSSNumericType type, double value) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public CSSNumericType getType() {
        return this.type;
    }

    public String getCSSText() {
        String typeText = this.type.getType();
        double value = this.getValue();
        if (typeText.length() == 0) {
            if (Math.floor(value) == value) {
                return String.valueOf((long)value);
            }
            return String.valueOf(value);
        }
        if (Math.floor(value) == value) {
            return (long)value + " " + typeText;
        }
        return value + " " + typeText;
    }

    public String toString() {
        return this.getCSSText();
    }

    public static CSSNumericValue createPtValue(double value) {
        return new CSSNumericValue(CSSNumericType.PT, value);
    }

    public static CSSNumericValue createValue(CSSNumericType type, double value) {
        return new CSSNumericValue(type, value);
    }
}

