/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.values;

import java.util.Collection;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.util.ObjectUtilities;

public final class CSSValueList
implements CSSValue,
Cloneable {
    private CSSValue[] values;

    public CSSValueList(Collection collection) {
        CSSValue[] values = new CSSValue[collection.size()];
        this.values = collection.toArray(values);
    }

    public CSSValueList(CSSValue[] values) {
        this.values = values;
    }

    public int getLength() {
        return this.values.length;
    }

    public CSSValue getItem(int index) {
        return this.values[index];
    }

    public String getCSSText() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            CSSValue value = this.values[i];
            if (i > 0) {
                b.append(" ");
            }
            b.append(value);
        }
        return b.toString();
    }

    public String toString() {
        return this.getCSSText();
    }

    public boolean contains(CSSValue value) {
        for (int i = 0; i < this.values.length; ++i) {
            CSSValue cssValue = this.values[i];
            if (!ObjectUtilities.equal((Object)cssValue, (Object)value)) continue;
            return true;
        }
        return false;
    }

    public static CSSValueList createList(CSSValue value) {
        return new CSSValueList(new CSSValue[]{value});
    }

    public static CSSValueList createDuoList(CSSValue value) {
        return CSSValueList.createDuoList(value, value);
    }

    public static CSSValueList createDuoList(CSSValue first, CSSValue second) {
        CSSValue[] values = new CSSValue[]{first, second};
        return new CSSValueList(values);
    }

    public static CSSValueList createQuadList(CSSValue value) {
        return CSSValueList.createQuadList(value, value);
    }

    public static CSSValueList createQuadList(CSSValue first, CSSValue second) {
        return CSSValueList.createQuadList(first, second, first, second);
    }

    public static CSSValueList createQuadList(CSSValue first, CSSValue second, CSSValue third, CSSValue fourth) {
        CSSValue[] values = new CSSValue[]{first, second, third, fourth};
        return new CSSValueList(values);
    }

    public static CSSValueList insertFirst(CSSValueList list, CSSValue value) {
        int length = list.values.length;
        CSSValue[] newValues = new CSSValue[length + 1];
        newValues[0] = value;
        System.arraycopy(list.values, 0, newValues, 1, length);
        return new CSSValueList(newValues);
    }

    public static CSSValueList insertLast(CSSValueList list, CSSValue value) {
        int length = list.values.length;
        CSSValue[] newValues = new CSSValue[length + 1];
        System.arraycopy(list.values, 0, newValues, 0, length);
        newValues[length] = value;
        return new CSSValueList(newValues);
    }

    public Object clone() {
        try {
            CSSValueList o = (CSSValueList)super.clone();
            o.values = (CSSValue[])this.values.clone();
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalAccessError("Clone cannot be unsupported.");
        }
    }
}

