/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.DefaultLayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.jfree.layouting.input.swing.converter.CharacterConverter;
import org.jfree.layouting.input.swing.converter.ColorConverter;
import org.jfree.layouting.input.swing.converter.DocumentConverter;
import org.jfree.layouting.input.swing.converter.FontConverter;
import org.jfree.layouting.input.swing.converter.ParagraphConverter;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.modules.output.html.StreamingHtmlOutputProcessor;

public class SwingDocumentImport {
    public static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String STYLESHEET_TYPE = "type";
    public static final String STYLESHEET_PCDATA = "#pcdata";
    public static final String STYLESHEET = "stylesheet";
    public static final String ELEMENT_STYLE_ATTRIBUTE = "style";
    private Map styleNames = new HashMap();
    private InputFeed feed;
    protected static Map styleConstantsMap = new HashMap();

    public InputFeed getFeed() {
        return this.feed;
    }

    public void setFeed(InputFeed feed) {
        this.feed = feed;
    }

    private String convertStyleName(String name) {
        return name;
    }

    public String getNormalizedStyleName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The style name must not be null");
        }
        String o = (String)this.styleNames.get(name);
        if (o == null) {
            o = this.convertStyleName(name);
            if (o == null) {
                throw new IllegalStateException("Unable to convert style name");
            }
            String res = this.styleNames.put(name, o);
            if (res != null) {
                throw new IllegalStateException("Style name clash during convertion");
            }
        }
        return o;
    }

    public ConverterAttributeSet convertAttributes(AttributeSet attr, Element context) throws InputFeedException {
        ConverterAttributeSet cssAttr = new ConverterAttributeSet();
        Enumeration<?> attributeNames = attr.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object key = attributeNames.nextElement();
            Object value = attr.getAttribute(key);
            Converter converter = (Converter)styleConstantsMap.get(key);
            if (converter != null) {
                ConverterAttributeSet attributeSet = converter.convertToCSS(key, value, cssAttr, context);
                if (attributeSet != null) {
                    cssAttr.addAttributes(attributeSet);
                    continue;
                }
                this.debugAttribut("No convertion for ", key, value);
                cssAttr.addAttribute(key, value);
                continue;
            }
            this.debugAttribut("No converter for ", key, value);
            cssAttr.addAttribute(key, value);
        }
        return cssAttr;
    }

    private void debugAttribut(String name, Object key, Object value) {
        System.out.println(name + "attribute [" + key.getClass().getName() + "] " + key + " = " + value + " [" + value.getClass().getName() + "]");
    }

    protected void handleElement(Element element) throws BadLocationException, InputFeedException {
        if (element == null) {
            return;
        }
        System.out.println("Stating Element: " + element.getName());
        this.feed.startElement(NAMESPACE, element.getName());
        AttributeSet as = element.getAttributes();
        ConverterAttributeSet cssAttr = this.convertAttributes(as, element);
        Enumeration<?> attributeNames = cssAttr.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object key = attributeNames.nextElement();
            Object value = cssAttr.getAttribute(key);
            if (key == StyleConstants.NameAttribute) continue;
            if (key == StyleConstants.ResolveAttribute && value instanceof Style) {
                Style style = (Style)value;
                this.feed.setAttribute(NAMESPACE, ELEMENT_STYLE_ATTRIBUTE, this.getNormalizedStyleName(style.getName()));
                continue;
            }
            this.debugAttribut("Element ", key, value);
            this.feed.setAttribute(NAMESPACE, key.toString(), value);
        }
        String text = this.getElementText(element);
        if ((text != null || !"".equals(text)) && element.isLeaf()) {
            System.out.println("'" + text + "'");
            this.feed.addContent(text);
        }
        int size = element.getElementCount();
        for (int i = 0; i < size; ++i) {
            Element e = element.getElement(i);
            this.handleElement(e);
        }
        this.feed.endElement();
    }

    protected String getElementText(Element element) throws BadLocationException {
        Document document = element.getDocument();
        String text = document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        return text;
    }

    protected void processStyleElements(DefaultStyledDocument document) throws InputFeedException {
        Enumeration<?> names = document.getStyleNames();
        while (names.hasMoreElements()) {
            String styleName = (String)names.nextElement();
            Style s = document.getStyle(styleName);
            if (s == null) continue;
            String convertedStyleName = this.getNormalizedStyleName(styleName);
            System.out.println("Processing style: " + styleName + "(" + convertedStyleName + ")");
            ConverterAttributeSet cssAttr = this.convertAttributes(s, null);
            Enumeration<?> attributeNames = cssAttr.getAttributeNames();
            StringBuffer buffer = new StringBuffer(cssAttr.getAttributeCount() * 4 + 5);
            this.feed.startMetaNode();
            buffer.append(convertedStyleName);
            buffer.append(" ");
            buffer.append(this.getParentSelector(s.getResolveParent()));
            buffer.append("{\n");
            while (attributeNames.hasMoreElements()) {
                Object key = attributeNames.nextElement();
                Object value = cssAttr.getAttribute(key);
                if (key == StyleConstants.NameAttribute || key == StyleConstants.ResolveAttribute) continue;
                this.debugAttribut("Style ", key, value);
                buffer.append(key.toString());
                buffer.append(":");
                buffer.append(value.toString());
                buffer.append(";\n");
            }
            buffer.append("}");
            this.feed.setMetaNodeAttribute(STYLESHEET_TYPE, STYLESHEET);
            this.feed.setMetaNodeAttribute(STYLESHEET_PCDATA, buffer.toString());
            this.feed.endMetaNode();
        }
    }

    private String getParentSelector(AttributeSet attributeSet) {
        if (attributeSet != null) {
            Object o = attributeSet.getAttribute(StyleConstants.ResolveAttribute);
            if (o != null) {
                Style s = (Style)o;
                return this.getNormalizedStyleName(s.getName()) + " " + this.getParentSelector(attributeSet.getResolveParent());
            }
        } else {
            return "";
        }
        return "";
    }

    protected void processDocumentProperties(DefaultStyledDocument document) throws InputFeedException {
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        Dictionary<Object, Object> documentProperties = document.getDocumentProperties();
        Enumeration<Object> keys = documentProperties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = documentProperties.get(key);
            attributeSet.addAttribute(key, value);
        }
        ConverterAttributeSet convertedSet = this.convertAttributes(attributeSet, null);
        this.processRules(convertedSet);
        AttributeSet documentAttributes = convertedSet.getAttributesByType(ConverterAttributeSet.NOT_TYPED);
        Enumeration<?> names = documentAttributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            Object value = documentAttributes.getAttribute(name);
            this.debugAttribut("Document Property ", name, value);
            this.feed.addDocumentAttribute(name.toString(), value);
        }
    }

    private void processRules(ConverterAttributeSet convertedSet) throws InputFeedException {
        AttributeSet pageRuleAttributes = convertedSet.getAttributesByType("@page");
        if (pageRuleAttributes.getAttributeCount() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("@page {\n");
            Enumeration<?> names = pageRuleAttributes.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                Object value = pageRuleAttributes.getAttribute(name);
                this.debugAttribut("Page rule attribute ", name, value);
                buffer.append(name.toString());
                buffer.append(":");
                buffer.append(value.toString());
                buffer.append(";\n");
            }
            buffer.append("}");
            this.feed.startMetaNode();
            this.feed.setMetaNodeAttribute(STYLESHEET_TYPE, STYLESHEET);
            this.feed.setMetaNodeAttribute(STYLESHEET_PCDATA, buffer.toString());
            this.feed.endMetaNode();
        }
    }

    public void parseDocument(DefaultStyledDocument doc, InputFeed feed) throws BadLocationException, InputFeedException {
        this.setFeed(feed);
        feed.startDocument();
        feed.startMetaInfo();
        this.processDocumentProperties(doc);
        this.processStyleElements(doc);
        feed.endMetaInfo();
        this.handleElement(doc.getDefaultRootElement());
        feed.endDocument();
    }

    public static void main(String[] args) throws IOException, BadLocationException, InputFeedException {
        URL initialPage = new URL("http://interglacial.com/rtf/rtf_book_examples/example_documents/p060_landscape_a4.rtf");
        initialPage.getContent();
        JEditorPane pane = new JEditorPane(initialPage);
        pane.setEditable(false);
        JFrame frame = new JFrame("HTML Viewer");
        frame.setSize(800, 600);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        JScrollPane scroll = new JScrollPane(pane, 20, 30);
        frame.getContentPane().add(scroll);
        frame.setVisible(true);
        LibLayoutBoot.getInstance().start();
        long startTime = System.currentTimeMillis();
        StreamingHtmlOutputProcessor outputProcessor = new StreamingHtmlOutputProcessor(LibLayoutBoot.getInstance().getGlobalConfig());
        DefaultLayoutProcess process = new DefaultLayoutProcess(outputProcessor);
        SwingDocumentImport imprt = new SwingDocumentImport();
        imprt.parseDocument((DefaultStyledDocument)pane.getDocument(), process.getInputFeed());
        long endTime = System.currentTimeMillis();
        System.out.println("Done!: " + (endTime - startTime));
    }

    static {
        FontConverter fontConverter = new FontConverter();
        styleConstantsMap.put(StyleConstants.FontFamily, fontConverter);
        styleConstantsMap.put(StyleConstants.FontSize, fontConverter);
        styleConstantsMap.put(StyleConstants.Bold, fontConverter);
        styleConstantsMap.put(StyleConstants.Italic, fontConverter);
        ParagraphConverter paragraphConverter = new ParagraphConverter();
        styleConstantsMap.put(StyleConstants.Alignment, paragraphConverter);
        styleConstantsMap.put(StyleConstants.LeftIndent, paragraphConverter);
        styleConstantsMap.put(StyleConstants.RightIndent, paragraphConverter);
        styleConstantsMap.put(StyleConstants.SpaceAbove, paragraphConverter);
        styleConstantsMap.put(StyleConstants.SpaceBelow, paragraphConverter);
        styleConstantsMap.put(StyleConstants.FirstLineIndent, paragraphConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        styleConstantsMap.put(StyleConstants.Underline, characterConverter);
        styleConstantsMap.put(StyleConstants.StrikeThrough, characterConverter);
        styleConstantsMap.put(StyleConstants.BidiLevel, characterConverter);
        styleConstantsMap.put(StyleConstants.Superscript, characterConverter);
        styleConstantsMap.put(StyleConstants.Subscript, characterConverter);
        styleConstantsMap.put("caps", characterConverter);
        styleConstantsMap.put("scaps", characterConverter);
        styleConstantsMap.put("outl", characterConverter);
        ColorConverter colorConverter = new ColorConverter();
        styleConstantsMap.put(StyleConstants.Foreground, colorConverter);
        styleConstantsMap.put(StyleConstants.Background, colorConverter);
        DocumentConverter documentConverter = new DocumentConverter();
        styleConstantsMap.put("paperw", documentConverter);
        styleConstantsMap.put("paperh", documentConverter);
        styleConstantsMap.put("margb", documentConverter);
        styleConstantsMap.put("margl", documentConverter);
        styleConstantsMap.put("margr", documentConverter);
        styleConstantsMap.put("margt", documentConverter);
        styleConstantsMap.put("landscape", documentConverter);
    }
}

