/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import java.util.StringTokenizer;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.input.style.keys.font.FontEffects;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontVariant;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextTransform;
import org.jfree.layouting.input.style.keys.text.UnicodeBidi;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.jfree.util.Log;

public class CharacterConverter
implements Converter {
    public static final String TEXT_DECORATION_KEY = "text-decoration";
    public static final String NONE_TEXT_DECORATION = "none";
    public static final String UNDERLINE_TEXT_DECORATION = "underline";
    public static final String LINETHROUGH_TEXT_DECORATION = "line-through";
    public static final String RTF_CAPS = "caps";
    public static final String RTF_SMALLCAPS = "scaps";
    public static final String RTF_OUTLINE = "outl";
    public static final String RTF_SHADOW = "shad";
    public static final String RTF_Hidden = "v";
    public static final String RTF_STRIKETRHOUGH = "strike";
    public static final String RTF_DELETED = "deleted";

    private Object mergeTextDecorationValues(Object current, Object newone) {
        boolean none = false;
        boolean underline = false;
        boolean strikethrough = false;
        if (newone == null) {
            return current;
        }
        String str = (String)current;
        str = str + " " + newone;
        StringTokenizer tokenizer = new StringTokenizer(str);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken().trim();
            if (NONE_TEXT_DECORATION.equals(s)) {
                none = true;
                continue;
            }
            if (UNDERLINE_TEXT_DECORATION.equals(s)) {
                underline = true;
                continue;
            }
            if (!LINETHROUGH_TEXT_DECORATION.equals(s)) continue;
            strikethrough = true;
        }
        if (underline && strikethrough) {
            return "underline line-through";
        }
        if (underline) {
            return UNDERLINE_TEXT_DECORATION;
        }
        if (strikethrough) {
            return LINETHROUGH_TEXT_DECORATION;
        }
        return NONE_TEXT_DECORATION;
    }

    public ConverterAttributeSet convertToCSS(Object key, Object value, ConverterAttributeSet cssAttr, Element context) {
        if (key instanceof StyleConstants.CharacterConstants) {
            StyleConstants.CharacterConstants characterConstant = (StyleConstants.CharacterConstants)key;
            return this.handleCharacterConstants(characterConstant, value, cssAttr);
        }
        if (key instanceof String) {
            String constant = (String)key;
            ConverterAttributeSet attr = new ConverterAttributeSet();
            if (constant.equals(RTF_SMALLCAPS)) {
                Boolean b = (Boolean)value;
                if (Boolean.TRUE.equals(b)) {
                    attr.addAttribute(FontStyleKeys.FONT_VARIANT.getName(), FontVariant.SMALL_CAPS);
                }
            } else if (constant.equals(RTF_CAPS)) {
                Boolean b = (Boolean)value;
                if (Boolean.TRUE.equals(b)) {
                    attr.addAttribute(TextStyleKeys.TEXT_TRANSFORM.getName(), TextTransform.CAPITALIZE);
                }
            } else if (constant.equals(RTF_OUTLINE)) {
                Boolean b = (Boolean)value;
                if (Boolean.TRUE.equals(b)) {
                    attr.addAttribute(FontStyleKeys.FONT_EFFECT, FontEffects.OUTLINE);
                }
            } else if (constant.equals(RTF_STRIKETRHOUGH)) {
                Object current = cssAttr.getAttribute(TEXT_DECORATION_KEY);
                attr.addAttribute(TEXT_DECORATION_KEY, this.mergeTextDecorationValues(current, LINETHROUGH_TEXT_DECORATION));
            } else {
                Log.debug((Object)new Log.SimpleMessage("Unkown type of character attribute", (Object)constant));
                return null;
            }
            return attr;
        }
        return null;
    }

    private ConverterAttributeSet handleCharacterConstants(StyleConstants.CharacterConstants characterConstant, Object value, ConverterAttributeSet cssAttr) {
        ConverterAttributeSet attr = new ConverterAttributeSet();
        if (characterConstant == StyleConstants.Underline) {
            Boolean b = (Boolean)value;
            if (Boolean.TRUE.equals(b)) {
                Object current = cssAttr.getAttribute(TEXT_DECORATION_KEY);
                attr.addAttribute(TEXT_DECORATION_KEY, this.mergeTextDecorationValues(current, UNDERLINE_TEXT_DECORATION));
            } else {
                attr.addAttribute(TEXT_DECORATION_KEY, NONE_TEXT_DECORATION);
            }
        } else if (characterConstant == StyleConstants.StrikeThrough) {
            Boolean b = (Boolean)value;
            if (Boolean.TRUE.equals(b)) {
                Object current = cssAttr.getAttribute(TEXT_DECORATION_KEY);
                attr.addAttribute(TEXT_DECORATION_KEY, this.mergeTextDecorationValues(current, LINETHROUGH_TEXT_DECORATION));
            } else {
                attr.addAttribute(TEXT_DECORATION_KEY, NONE_TEXT_DECORATION);
            }
        } else if (characterConstant == StyleConstants.Superscript) {
            Boolean b = (Boolean)value;
            if (Boolean.TRUE.equals(b)) {
                attr.addAttribute(LineStyleKeys.VERTICAL_ALIGN.getName(), VerticalAlign.SUPER);
            }
        } else if (characterConstant == StyleConstants.Subscript) {
            Boolean b = (Boolean)value;
            if (Boolean.TRUE.equals(b)) {
                attr.addAttribute(LineStyleKeys.VERTICAL_ALIGN.getName(), VerticalAlign.SUB);
            }
        } else if (characterConstant == StyleConstants.BidiLevel) {
            Boolean b = (Boolean)value;
            if (Boolean.TRUE.equals(b)) {
                attr.addAttribute(TextStyleKeys.UNICODE_BIDI.getName(), UnicodeBidi.EMBED);
            } else {
                attr.addAttribute(TextStyleKeys.UNICODE_BIDI.getName(), UnicodeBidi.NORMAL);
            }
        } else {
            Log.debug((Object)new Log.SimpleMessage("Unkown type of character attribute", (Object)characterConstant));
            return null;
        }
        return cssAttr;
    }
}

