/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import java.awt.Color;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.color.ColorStyleKeys;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.jfree.util.Log;

public class ColorConverter
implements Converter {
    public ConverterAttributeSet convertToCSS(Object key, Object value, ConverterAttributeSet cssAttr, Element context) {
        if (key instanceof StyleConstants.ColorConstants) {
            StyleConstants.ColorConstants colorConstant = (StyleConstants.ColorConstants)key;
            return this.handleColorConstants(colorConstant, value);
        }
        return null;
    }

    private ConverterAttributeSet handleColorConstants(StyleConstants.ColorConstants colorConstant, Object value) {
        ConverterAttributeSet attr = new ConverterAttributeSet();
        if (colorConstant == StyleConstants.Foreground) {
            CSSColorValue cssColorValue = new CSSColorValue((Color)value);
            attr.addAttribute(ColorStyleKeys.COLOR.getName(), cssColorValue);
        } else if (colorConstant == StyleConstants.Background) {
            CSSColorValue cssColorValue = new CSSColorValue((Color)value);
            attr.addAttribute(BorderStyleKeys.BACKGROUND_COLOR.getName(), cssColorValue);
        } else {
            Log.debug((Object)new Log.SimpleMessage("Unkown type of color attribute", (Object)colorConstant));
            return null;
        }
        return attr;
    }
}

