/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.input.style.keys.font.FontStyle;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontWeight;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.jfree.util.Log;

public class FontConverter
implements Converter {
    public ConverterAttributeSet convertToCSS(Object key, Object value, ConverterAttributeSet cssAttr, Element context) {
        if (key instanceof StyleConstants.FontConstants) {
            StyleConstants.FontConstants fontConstant = (StyleConstants.FontConstants)key;
            return this.handleFontConstants(fontConstant, value);
        }
        return null;
    }

    protected ConverterAttributeSet handleFontConstants(StyleConstants.FontConstants fontConstant, Object value) {
        ConverterAttributeSet attr = new ConverterAttributeSet();
        if (fontConstant == StyleConstants.FontFamily) {
            attr.addAttribute(FontStyleKeys.FONT_FAMILY.getName(), value);
        } else if (fontConstant == StyleConstants.FontSize) {
            attr.addAttribute(FontStyleKeys.FONT_SIZE.getName(), value);
        } else if (fontConstant == StyleConstants.Bold) {
            Boolean b = (Boolean)value;
            if (Boolean.TRUE.equals(b)) {
                attr.addAttribute(FontStyleKeys.FONT_WEIGHT.getName(), FontWeight.BOLD);
            } else {
                attr.addAttribute(FontStyleKeys.FONT_WEIGHT.getName(), FontWeight.NORMAL);
            }
        } else if (fontConstant == StyleConstants.Italic) {
            Boolean b = (Boolean)value;
            if (Boolean.TRUE.equals(b)) {
                attr.addAttribute(FontStyleKeys.FONT_STYLE.getName(), FontStyle.ITALIC);
            } else {
                attr.addAttribute(FontStyleKeys.FONT_STYLE.getName(), FontStyle.NORMAL);
            }
        } else {
            Log.debug((Object)new Log.SimpleMessage("Unkown type of font attribute", (Object)fontConstant));
            return null;
        }
        return attr;
    }
}

