/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.xhtml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jfree.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XhtmlDocument
implements Serializable {
    private transient Document document;
    private transient byte[] data;
    private URL source;
    private transient boolean hasErrors;

    public XhtmlDocument(URL source, byte[] data, Document document) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.source = source;
        this.document = document;
    }

    protected byte[] getData() {
        if (this.data == null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream inputStream = this.source.openStream();
                IOUtils.getInstance().copyStreams(inputStream, (OutputStream)bout);
                this.data = bout.toByteArray();
            }
            catch (IOException e) {
                this.data = new byte[0];
            }
        }
        return this.data;
    }

    public URL getSource() {
        return this.source;
    }

    public Document getDocument() {
        if (this.hasErrors) {
            return null;
        }
        if (this.document == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource(new ByteArrayInputStream(this.getData()));
                Document doc = db.parse(is);
                return doc;
            }
            catch (Exception ioe) {
                this.document = null;
                this.hasErrors = true;
            }
        }
        return this.document;
    }
}

