/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.keys.page.PagePolicy;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DefaultDocumentMetaNode;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.DocumentMetaNode;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.layouter.counters.numeric.DecimalCounterStyle;
import org.jfree.layouting.layouter.i18n.DefaultLocalizationContext;
import org.jfree.layouting.namespace.DefaultNamespaceCollection;
import org.jfree.layouting.namespace.DefaultNamespaceDefinition;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.namespace.Namespaces;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;

public class DefaultDocumentContext
extends DefaultDocumentMetaNode
implements DocumentContext {
    private ArrayList metaNodes = new ArrayList();
    private HashMap counterStyles = new HashMap();
    private HashMap counterPolicy = new HashMap();
    private HashMap stringPolicy = new HashMap();
    private DefaultNamespaceCollection namespaceCollection;
    private int quoteLevel;

    public DefaultDocumentContext() {
        this.setMetaAttribute("date", new Date());
        this.setMetaAttribute("localization-context", new DefaultLocalizationContext());
    }

    public CSSValue getStringPolicy(String name) {
        CSSValue cssValue = (CSSValue)this.stringPolicy.get(name);
        if (cssValue == null) {
            return PagePolicy.LAST;
        }
        return cssValue;
    }

    public void setStringPolicy(String name, CSSValue policy) {
        this.stringPolicy.put(name, policy);
    }

    public CSSValue getCounterPolicy(String name) {
        CSSValue cssValue = (CSSValue)this.counterPolicy.get(name);
        if (cssValue == null) {
            return PagePolicy.LAST;
        }
        return cssValue;
    }

    public void setCounterPolicy(String name, CSSValue policy) {
        this.counterPolicy.put(name, policy);
    }

    public void addMetaNode(DocumentMetaNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (node instanceof DocumentContext) {
            throw new IllegalArgumentException();
        }
        this.metaNodes.add(node);
    }

    public void removeMetaNode(DocumentMetaNode node) {
        this.metaNodes.remove(node);
    }

    public DocumentMetaNode getMetaNode(int index) {
        return (DocumentMetaNode)this.metaNodes.get(index);
    }

    public int getMetaNodeCount() {
        return this.metaNodes.size();
    }

    public ResourceManager getResourceManager() {
        Object o = this.getMetaAttribute("resource-manager");
        if (!(o instanceof ResourceManager)) {
            ResourceManager value = new ResourceManager();
            value.registerDefaults();
            this.setMetaAttribute("resource-manager", value);
            return value;
        }
        return (ResourceManager)o;
    }

    public void setCounterStyle(String counterName, CounterStyle style) {
        this.counterStyles.put(counterName, style);
    }

    public CounterStyle getCounterStyle(String counterName) {
        CounterStyle style = (CounterStyle)this.counterStyles.get(counterName);
        if (style == null) {
            return new DecimalCounterStyle();
        }
        return style;
    }

    public void initialize() {
        int i;
        this.namespaceCollection = new DefaultNamespaceCollection();
        Log.debug((Object)"Initializing document context");
        NamespaceDefinition[] defaults = Namespaces.createFromConfig(LibLayoutBoot.getInstance().getGlobalConfig(), "org.jfree.layouting.namespaces.", this.getResourceManager());
        for (i = 0; i < defaults.length; ++i) {
            NamespaceDefinition definition = defaults[i];
            this.namespaceCollection.addDefinition(definition);
        }
        for (i = 0; i < this.metaNodes.size(); ++i) {
            DocumentMetaNode metaNode = (DocumentMetaNode)this.metaNodes.get(i);
            Object nodeType = metaNode.getMetaAttribute("type");
            if (!"namespace".equals(nodeType)) continue;
            Object def = metaNode.getMetaAttribute("definition");
            if (def instanceof NamespaceDefinition) {
                this.namespaceCollection.addDefinition((NamespaceDefinition)def);
                continue;
            }
            String uri = (String)metaNode.getMetaAttribute("uri");
            String prefix = (String)metaNode.getMetaAttribute("prefix");
            String classAttr = (String)metaNode.getMetaAttribute("class-attribute");
            String styleAttr = (String)metaNode.getMetaAttribute("style-attribute");
            ResourceKey styleSheetLocation = (ResourceKey)metaNode.getMetaAttribute("default-stylesheet");
            this.namespaceCollection.addDefinition(new DefaultNamespaceDefinition(uri, styleSheetLocation, classAttr, styleAttr, prefix));
        }
    }

    public NamespaceCollection getNamespaces() {
        return this.namespaceCollection;
    }

    public int getQuoteLevel() {
        return this.quoteLevel;
    }

    public void openQuote() {
        ++this.quoteLevel;
    }

    public void closeQuote() {
        --this.quoteLevel;
        if (this.quoteLevel < 0) {
            this.quoteLevel = 0;
        }
    }
}

