/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import org.jfree.layouting.input.style.keys.font.FontSmooth;
import org.jfree.layouting.input.style.keys.font.FontStyle;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontVariant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutStyle;

public class FontSpecification {
    private LayoutStyle style;
    private double fontSize;
    private String fontFamily;
    private boolean antiAliasing;

    public FontSpecification(LayoutStyle style) {
        if (style == null) {
            throw new NullPointerException("Style must not be null.");
        }
        this.style = style;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public int getFontWeight() {
        CSSValue val = this.style.getValue(FontStyleKeys.FONT_WEIGHT);
        if (!(val instanceof CSSNumericValue)) {
            return 0;
        }
        CSSNumericValue nval = (CSSNumericValue)val;
        return (int)nval.getValue();
    }

    public boolean isItalic() {
        CSSValue value = this.style.getValue(FontStyleKeys.FONT_STYLE);
        return FontStyle.ITALIC.equals(value) || FontStyle.OBLIQUE.equals(value);
    }

    public boolean isOblique() {
        CSSValue value = this.style.getValue(FontStyleKeys.FONT_STYLE);
        return FontStyle.OBLIQUE.equals(value);
    }

    public boolean isSmallCaps() {
        return FontVariant.SMALL_CAPS.equals(this.style.getValue(FontStyleKeys.FONT_VARIANT));
    }

    public boolean isAntiAliasing() {
        CSSValue value = this.style.getValue(FontStyleKeys.X_FONT_SMOOTH_FLAG);
        return FontSmooth.ALWAYS.equals(value);
    }
}

