/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.model;

import java.util.HashMap;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutNode;

public class LayoutElement
extends LayoutNode {
    private LayoutElement previous;
    private LayoutContext layoutContext;
    private HashMap strings;
    private HashMap counters;
    private boolean contentsConsumed;
    private int alternateOpen;

    public LayoutElement(LayoutElement parent, LayoutElement previous, LayoutContext layoutContext) {
        super(parent);
        if (layoutContext == null) {
            throw new NullPointerException();
        }
        this.previous = previous;
        this.layoutContext = layoutContext;
    }

    public LayoutElement getPrevious() {
        return this.previous;
    }

    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    public LayoutContext detachLayoutContext() {
        return this.layoutContext.detach(this.counters, this.strings);
    }

    public boolean isContentsConsumed() {
        LayoutElement parent;
        if (this.isPseudoElement() && (parent = this.getParent()) != null) {
            return parent.isContentsConsumed();
        }
        return this.contentsConsumed;
    }

    private boolean isPseudoElement() {
        if (this.layoutContext == null) {
            return false;
        }
        return this.layoutContext.isPseudoElement();
    }

    public void setContentsConsumed(boolean contentsConsumed) {
        LayoutElement parent;
        if (this.isPseudoElement() && (parent = this.getParent()) != null) {
            parent.setContentsConsumed(contentsConsumed);
            return;
        }
        this.contentsConsumed = contentsConsumed;
    }

    public int getCounterValue(String counterName) {
        Integer counterValue;
        if (this.counters != null && (counterValue = (Integer)this.counters.get(counterName)) != null) {
            return counterValue;
        }
        if (this.getParent() != null) {
            return this.getParent().getCounterValue(counterName);
        }
        return 0;
    }

    public void incrementCounter(String name, int value) {
        if (this.counters != null && this.counters.containsKey(name)) {
            int oldValue = this.getCounterValue(name);
            this.counters.put(name, new Integer(oldValue + value));
            return;
        }
        if (this.getParent() != null) {
            this.getParent().incrementCounter(name, value);
            return;
        }
        int oldValue = this.getCounterValue(name);
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(name, new Integer(oldValue + value));
    }

    public void resetCounter(String name, int value) {
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(name, new Integer(value));
    }

    public boolean isCounterDefined(String counterName) {
        if (this.counters == null) {
            return false;
        }
        return this.counters.containsKey(counterName);
    }

    public void setString(String name, String value, boolean define) {
        if (!define && this.getParent() != null) {
            this.getParent().setString(name, value, define);
            return;
        }
        if (value == null) {
            if (this.strings != null) {
                this.strings.remove(name);
            }
        } else {
            if (this.strings == null) {
                this.strings = new HashMap();
            }
            this.strings.put(name, value);
        }
    }

    public String getString(String name) {
        String value;
        if (this.strings != null && (value = (String)this.strings.get(name)) != null) {
            return value;
        }
        if (this.getParent() != null) {
            return this.getParent().getString(name);
        }
        return null;
    }

    public void openAlternate() {
        ++this.alternateOpen;
    }

    public boolean isAlternateOpen() {
        return this.alternateOpen != 0;
    }
}

