/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style;

import org.jfree.fonts.registry.FontMetrics;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorFeature;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.util.geom.StrictGeomUtility;

public class CSSValueResolverUtility {
    public static final double DEFAULT_X_HEIGHT_FACTOR = 0.58;
    private static CSSNumericType[] types = new CSSNumericType[]{CSSNumericType.CM, CSSNumericType.MM, CSSNumericType.PX, CSSNumericType.PT, CSSNumericType.PC, CSSNumericType.INCH};
    private static double[] vals = new double[]{254.0, 2540.0, 9600.0, 7200.0, 600.0, 100.0};

    public static boolean isAbsoluteValue(CSSNumericValue value) {
        if (CSSNumericType.PT.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.PC.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.INCH.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.CM.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.MM.equals(value.getType())) {
            return true;
        }
        return CSSNumericType.PX.equals(value.getType());
    }

    public static boolean isLengthValue(CSSNumericValue value) {
        if (CSSNumericType.PT.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.PC.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.INCH.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.CM.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.MM.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.EM.equals(value.getType())) {
            return true;
        }
        if (CSSNumericType.EX.equals(value.getType())) {
            return true;
        }
        return CSSNumericType.PX.equals(value.getType());
    }

    public static double convertLengthToDouble(CSSValue rawValue) {
        return CSSValueResolverUtility.convertLengthToDouble(rawValue, null, null);
    }

    public static strictfp double convertLengthToDouble(CSSValue rawValue, LayoutContext context, OutputProcessorMetaData metaData) {
        if (!(rawValue instanceof CSSNumericValue)) {
            return 0.0;
        }
        CSSNumericValue value = (CSSNumericValue)rawValue;
        if (CSSNumericType.PT.equals(value.getType())) {
            return value.getValue();
        }
        if (CSSNumericType.PC.equals(value.getType())) {
            return value.getValue() / 12.0;
        }
        if (CSSNumericType.INCH.equals(value.getType())) {
            return value.getValue() / 72.0;
        }
        if (CSSNumericType.CM.equals(value.getType())) {
            return value.getValue() * 100.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.MM.equals(value.getType())) {
            return value.getValue() * 10.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.PX.equals(value.getType())) {
            int pixelPerInch = metaData != null ? (int)metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION) : 96;
            if (pixelPerInch <= 0) {
                return value.getValue();
            }
            return value.getValue() * 72.0 / (double)pixelPerInch;
        }
        if (metaData == null) {
            return 0.0;
        }
        if (context != null) {
            if (CSSNumericType.EM.equals(value.getType())) {
                FontSpecification fspec = context.getFontSpecification();
                double fontSize = fspec.getFontSize();
                return fontSize * value.getValue();
            }
            if (CSSNumericType.EX.equals(value.getType())) {
                FontSpecification fspec = context.getFontSpecification();
                FontMetrics fontMetrics = metaData.getFontMetrics(fspec);
                if (fontMetrics == null) {
                    double fontSize = fspec.getFontSize() * 0.58;
                    return value.getValue() * fontSize;
                }
                return value.getValue() * fontMetrics.getXHeight();
            }
        }
        return 0.0;
    }

    public static strictfp long convertLengthToLong(CSSValue rawValue, LayoutContext context, OutputProcessorMetaData metaData) {
        if (!(rawValue instanceof CSSNumericValue)) {
            return 0L;
        }
        CSSNumericValue value = (CSSNumericValue)rawValue;
        long internal = StrictGeomUtility.toInternalValue(value.getValue());
        if (CSSNumericType.PT.equals(value.getType())) {
            return internal;
        }
        if (CSSNumericType.PC.equals(value.getType())) {
            return internal / 12L;
        }
        if (CSSNumericType.INCH.equals(value.getType())) {
            return internal / 72L;
        }
        if (CSSNumericType.CM.equals(value.getType())) {
            return internal * 100L * 72L / 254L;
        }
        if (CSSNumericType.MM.equals(value.getType())) {
            return internal * 10L * 72L / 254L;
        }
        if (CSSNumericType.PX.equals(value.getType())) {
            int pixelPerInch = metaData != null ? (int)metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION) : 96;
            if (pixelPerInch <= 0) {
                return internal;
            }
            return internal * 72L / (long)pixelPerInch;
        }
        if (metaData == null) {
            return 0L;
        }
        if (context != null) {
            if (CSSNumericType.EM.equals(value.getType())) {
                FontSpecification fspec = context.getFontSpecification();
                double fontSize = fspec.getFontSize();
                return (long)(fontSize * (double)internal);
            }
            if (CSSNumericType.EX.equals(value.getType())) {
                FontSpecification fspec = context.getFontSpecification();
                FontMetrics fontMetrics = metaData.getFontMetrics(fspec);
                if (fontMetrics == null) {
                    double fontSize = fspec.getFontSize() * 0.58;
                    return (long)((double)internal * fontSize);
                }
                return (long)((double)internal * fontMetrics.getXHeight());
            }
        }
        return 0L;
    }

    public static CSSNumericValue convertLength(CSSValue rawValue, LayoutContext context, OutputProcessorMetaData metaData) {
        return CSSNumericValue.createValue(CSSNumericType.PT, CSSValueResolverUtility.convertLengthToDouble(rawValue, context, metaData));
    }

    public static CSSNumericValue getLength(CSSValue value) {
        if (!(value instanceof CSSNumericValue)) {
            return null;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (CSSValueResolverUtility.isNumericType(CSSNumericType.PERCENTAGE, nval)) {
            return null;
        }
        return nval;
    }

    private static boolean isNumericType(CSSNumericType type, CSSValue value) {
        if (!(value instanceof CSSNumericValue)) {
            return false;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        return nval.getType().equals(type);
    }

    public static CSSNumericValue getLength(CSSValue value, CSSNumericValue percentageBase) {
        if (!(value instanceof CSSNumericValue)) {
            return null;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (CSSValueResolverUtility.isNumericType(CSSNumericType.PERCENTAGE, nval)) {
            if (percentageBase == null) {
                return null;
            }
            double percentage = nval.getValue();
            return CSSNumericValue.createValue(percentageBase.getType(), percentageBase.getValue() * percentage / 100.0);
        }
        return nval;
    }

    public static boolean isURI(CSSValue value) {
        if (!(value instanceof CSSStringValue)) {
            return false;
        }
        CSSStringValue sval = (CSSStringValue)value;
        return sval.getType().equals(CSSStringType.URI);
    }

    public static double getNumericValue(CSSValue value, double defaultValue) {
        CSSNumericValue nval;
        if (value instanceof CSSNumericValue && CSSNumericType.NUMBER.equals((nval = (CSSNumericValue)value).getType())) {
            return nval.getValue();
        }
        return defaultValue;
    }

    public static CSSNumericValue convertLength(CSSNumericValue value, CSSNumericType type) {
        if (type == CSSNumericType.NUMBER || type == CSSNumericType.PERCENTAGE || type == CSSNumericType.DEG) {
            throw new IllegalArgumentException();
        }
        CSSNumericType valueType = value.getType();
        if (valueType == CSSNumericType.NUMBER || valueType == CSSNumericType.PERCENTAGE || valueType == CSSNumericType.DEG) {
            throw new IllegalArgumentException();
        }
        if (valueType == type) {
            return value;
        }
        double targetFactor = CSSValueResolverUtility.getFactor(type);
        double sourceFactor = CSSValueResolverUtility.getFactor(valueType);
        double unitvalue = value.getValue() * targetFactor / sourceFactor;
        return CSSNumericValue.createValue(type, unitvalue);
    }

    private static double getFactor(CSSNumericType type) {
        for (int i = 0; i < types.length; ++i) {
            CSSNumericType numericType = types[i];
            if (type != numericType) continue;
            return vals[i];
        }
        throw new IllegalArgumentException();
    }

    private CSSValueResolverUtility() {
    }
}

