/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions;

import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceManager;

public class FunctionUtilities {
    private static CSSNumericType[] KNOWN_TYPES = new CSSNumericType[]{CSSNumericType.PERCENTAGE, CSSNumericType.EM, CSSNumericType.EX, CSSNumericType.CM, CSSNumericType.MM, CSSNumericType.INCH, CSSNumericType.PT, CSSNumericType.PC, CSSNumericType.DEG, CSSNumericType.PX};

    private FunctionUtilities() {
    }

    public static CSSResourceValue loadResource(LayoutProcess process, Object value) throws FunctionEvaluationException {
        Class[] supportedResourceTypes = process.getOutputMetaData().getSupportedResourceTypes();
        if (supportedResourceTypes.length == 0) {
            throw new FunctionEvaluationException("Failed to create URI: Resource loading failed as the output target does not support any resource types.");
        }
        return FunctionUtilities.loadResource(process, value, supportedResourceTypes);
    }

    public static CSSResourceValue loadResource(LayoutProcess process, Object value, Class[] type) throws FunctionEvaluationException {
        ResourceManager manager = process.getResourceManager();
        ResourceKey baseKey = DocumentContextUtility.getBaseResource(process.getDocumentContext());
        try {
            ResourceKey key;
            if (value instanceof ResourceKey) {
                key = (ResourceKey)value;
            } else if (baseKey == null) {
                key = manager.createKey(value);
            } else if (value instanceof String) {
                key = manager.deriveKey(baseKey, (String)value);
            } else {
                throw new FunctionEvaluationException("Failed to create URI: Resource loading failed: Key not derivable");
            }
            Resource res = manager.create(key, baseKey, type);
            return new CSSResourceValue(res);
        }
        catch (Exception e) {
            throw new FunctionEvaluationException("Failed to create URI: Resource loading failed: " + e.getMessage(), e);
        }
    }

    public static CSSValue parseValue(LayoutProcess process, String text) {
        CSSNumericValue val = FunctionUtilities.convertToNumber(text);
        if (val != null) {
            return val;
        }
        try {
            return FunctionUtilities.loadResource(process, text);
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            return new CSSStringValue(CSSStringType.STRING, text);
        }
    }

    public static CSSNumericValue parseNumberValue(String text, String type) throws FunctionEvaluationException {
        CSSNumericValue val = FunctionUtilities.convertToNumber(text, FunctionUtilities.getUnitType(type));
        if (val != null) {
            return val;
        }
        throw new FunctionEvaluationException("Unable to convert to number.");
    }

    public static CSSNumericValue parseNumberValue(String text) throws FunctionEvaluationException {
        CSSNumericValue val = FunctionUtilities.convertToNumber(text);
        if (val != null) {
            return val;
        }
        throw new FunctionEvaluationException("Unable to convert to number.");
    }

    private static CSSNumericValue convertToNumber(String stringValue) {
        String txt = stringValue.trim();
        CSSNumericType type = null;
        for (int i = 0; i < KNOWN_TYPES.length; ++i) {
            CSSNumericType numericType = KNOWN_TYPES[i];
            if (!txt.endsWith(numericType.getType())) continue;
            type = numericType;
        }
        if (type == null) {
            type = CSSNumericType.NUMBER;
        }
        String number = txt.substring(0, txt.length() - type.getType().length()).trim();
        return FunctionUtilities.convertToNumber(number, type);
    }

    private static CSSNumericValue convertToNumber(String stringValue, CSSNumericType type) {
        if (type == null) {
            type = CSSNumericType.NUMBER;
        }
        try {
            String number = stringValue.trim();
            double nVal = Double.parseDouble(number);
            return CSSNumericValue.createValue(type, nVal);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CSSNumericType getUnitType(String typeText) {
        if (typeText == null) {
            return CSSNumericType.NUMBER;
        }
        String txt = typeText.trim();
        for (int i = 0; i < KNOWN_TYPES.length; ++i) {
            CSSNumericType numericType = KNOWN_TYPES[i];
            if (!txt.equalsIgnoreCase(numericType.getType())) continue;
            return numericType;
        }
        return CSSNumericType.NUMBER;
    }

    public static String resolveString(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSValue value) throws FunctionEvaluationException {
        CSSValue notAFunctionAnymore = FunctionUtilities.resolveParameter(layoutProcess, layoutElement, value);
        if (notAFunctionAnymore instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)notAFunctionAnymore;
            return strVal.getValue();
        }
        String retval = notAFunctionAnymore.getCSSText();
        if (retval == null) {
            throw new FunctionEvaluationException("Value " + notAFunctionAnymore + " is invalid");
        }
        return retval;
    }

    public static CSSValue resolveParameter(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSValue value) throws FunctionEvaluationException {
        if (!(value instanceof CSSFunctionValue)) {
            return value;
        }
        CSSFunctionValue functionValue = (CSSFunctionValue)value;
        StyleValueFunction function = FunctionFactory.getInstance().getStyleFunction(functionValue.getFunctionName());
        if (function == null) {
            throw new FunctionEvaluationException("Unsupported Function: " + functionValue);
        }
        return function.evaluate(layoutProcess, layoutElement, functionValue);
    }

    public static ResourceKey createURI(String uri, LayoutProcess layoutProcess) {
        try {
            DocumentContext context = layoutProcess.getDocumentContext();
            ResourceKey base = DocumentContextUtility.getBaseResource(context);
            ResourceManager resourceManager = layoutProcess.getResourceManager();
            if (base != null) {
                try {
                    return resourceManager.deriveKey(base, uri);
                }
                catch (ResourceKeyCreationException ex) {
                    // empty catch block
                }
            }
            return resourceManager.createKey((Object)uri);
        }
        catch (Exception e) {
            return null;
        }
    }
}

