/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.FormattedContentToken;
import org.jfree.layouting.layouter.i18n.LocalizationContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;

public class DateValueFunction
implements ContentFunction {
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        Date date = DocumentContextUtility.getDate(layoutProcess.getDocumentContext());
        CSSValue[] parameters = function.getParameters();
        LocalizationContext localizationContext = DocumentContextUtility.getLocalizationContext(layoutProcess.getDocumentContext());
        DateFormat format = this.getDateFormat(parameters, localizationContext, element.getLayoutContext().getLanguage());
        return new FormattedContentToken(date, format, format.format(date));
    }

    private DateFormat getDateFormat(CSSValue[] parameters, LocalizationContext localizationContext, Locale locale) {
        if (parameters.length < 1) {
            return localizationContext.getDateFormat(locale);
        }
        CSSValue formatValue = parameters[0];
        if (!(formatValue instanceof CSSStringValue)) {
            return localizationContext.getDateFormat(locale);
        }
        CSSStringValue sval = (CSSStringValue)formatValue;
        DateFormat format = localizationContext.getDateFormat(sval.getValue(), locale);
        if (format != null) {
            return format;
        }
        return localizationContext.getDateFormat(locale);
    }
}

