/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import java.text.Format;
import java.util.Date;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.FormattedContentToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.i18n.LocalizationContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.values.CSSFormatedValue;
import org.jfree.layouting.layouter.style.values.CSSRawValue;

public class FormatValueFunction
implements ContentFunction {
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length < 2) {
            throw new FunctionEvaluationException("Illegal parameter count");
        }
        CSSValue rawValue = FunctionUtilities.resolveParameter(layoutProcess, element, params[0]);
        String typeValue = FunctionUtilities.resolveString(layoutProcess, element, params[1]);
        LocalizationContext localizationContext = DocumentContextUtility.getLocalizationContext(layoutProcess.getDocumentContext());
        LayoutContext layoutContext = element.getLayoutContext();
        if ("date".equals(typeValue)) {
            if (params.length < 3) {
                return this.getDateValue(rawValue, localizationContext.getDateFormat(layoutContext.getLanguage()));
            }
            String format = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
            return this.getDateValue(rawValue, localizationContext.getDateFormat(format, layoutContext.getLanguage()));
        }
        if ("time".equals(typeValue)) {
            if (params.length != 2) {
                throw new FunctionEvaluationException();
            }
            return this.getDateValue(rawValue, localizationContext.getTimeFormat(layoutContext.getLanguage()));
        }
        if ("number".equals(typeValue)) {
            if (params.length < 3) {
                return this.getNumberValue(rawValue, localizationContext.getDateFormat(layoutContext.getLanguage()));
            }
            String format = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
            return this.getNumberValue(rawValue, localizationContext.getNumberFormat(format, layoutContext.getLanguage()));
        }
        if ("integer".equals(typeValue)) {
            if (params.length != 2) {
                throw new FunctionEvaluationException();
            }
            return this.getNumberValue(rawValue, localizationContext.getIntegerFormat(layoutContext.getLanguage()));
        }
        throw new FunctionEvaluationException("FormatType not recognized");
    }

    private ContentToken getNumberValue(CSSValue rawValue, Format format) throws FunctionEvaluationException {
        double number;
        if (rawValue instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)rawValue;
            try {
                CSSNumericValue nval = FunctionUtilities.parseNumberValue(strVal.getValue());
                number = nval.getValue();
            }
            catch (FunctionEvaluationException fee) {
                return new StaticTextToken(strVal.getValue());
            }
        } else if (rawValue instanceof CSSNumericValue) {
            CSSNumericValue nval = (CSSNumericValue)rawValue;
            number = nval.getValue();
        } else {
            throw new FunctionEvaluationException("Not a numeric value.");
        }
        Double obj = new Double(number);
        return new FormattedContentToken(obj, format, format.format(obj));
    }

    private FormattedContentToken getDateValue(CSSValue rawValue, Format format) throws FunctionEvaluationException {
        Date date;
        if (rawValue instanceof CSSRawValue) {
            CSSRawValue cssRawValue = (CSSRawValue)rawValue;
            Object o = cssRawValue.getValue();
            if (!(o instanceof Date)) {
                throw new FunctionEvaluationException("Not a date value.");
            }
            date = (Date)o;
        } else if (rawValue instanceof CSSFormatedValue) {
            CSSFormatedValue fval = (CSSFormatedValue)rawValue;
            Object o = fval.getRaw();
            if (!(o instanceof Date)) {
                throw new FunctionEvaluationException("Not a date value.");
            }
            date = (Date)o;
        } else {
            throw new FunctionEvaluationException("Not a date value.");
        }
        return new FormattedContentToken(date, format, format.format(date));
    }
}

