/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.values;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;

public class RgbValueFunction
implements StyleValueFunction {
    protected int validateParameter(CSSValue value) throws FunctionEvaluationException {
        CSSNumericValue nval;
        if (value instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)value;
            nval = FunctionUtilities.parseNumberValue(strVal.getValue());
        } else {
            if (!(value instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            nval = (CSSNumericValue)value;
        }
        if (nval.getType().equals(CSSNumericType.NUMBER)) {
            return (int)(nval.getValue() % 256.0);
        }
        if (nval.getType().equals(CSSNumericType.PERCENTAGE)) {
            return (int)(nval.getValue() * 256.0 / 100.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    public CSSValue evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] values = function.getParameters();
        if (values.length == 3) {
            int redValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            int greenValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            int blueValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            return new CSSColorValue(redValue, greenValue, blueValue);
        }
        if (values.length == 4) {
            int redValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            int greenValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            int blueValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            int alphaValue = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[3]));
            return new CSSColorValue(redValue, greenValue, blueValue, alphaValue);
        }
        throw new FunctionEvaluationException("Expected either three or four parameters.");
    }
}

