/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.layouter.style.resolver.ResolveHandlerModule;
import org.jfree.layouting.layouter.style.resolver.ResolveHandlerSorter;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class ResolverFactory {
    private static final String AUTO_PREFIX = "org.jfree.layouting.resolver.auto.";
    private static final String COMPUTED_PREFIX = "org.jfree.layouting.resolver.computed.";
    private static final String PERCENTAGE_PREFIX = "org.jfree.layouting.resolver.percentages.";
    private static ResolverFactory factory;
    private ResolveHandlerModule[] handlers = null;
    private StyleKeyRegistry registry = StyleKeyRegistry.getRegistry();
    static /* synthetic */ Class class$org$jfree$layouting$layouter$style$resolver$ResolverFactory;
    static /* synthetic */ Class class$org$jfree$layouting$layouter$style$resolver$ResolveHandler;

    public static synchronized ResolverFactory getInstance() {
        if (factory == null) {
            factory = new ResolverFactory();
            factory.registerDefaults();
        }
        return factory;
    }

    private ResolverFactory() {
    }

    public void registerDefaults() {
        ArrayList<ResolveHandlerModule> handlerList = new ArrayList<ResolveHandlerModule>();
        HashMap autoHandlers = this.loadModules(AUTO_PREFIX);
        HashMap compHandlers = this.loadModules(COMPUTED_PREFIX);
        HashMap percHandlers = this.loadModules(PERCENTAGE_PREFIX);
        HashSet keys = new HashSet();
        keys.addAll(autoHandlers.keySet());
        keys.addAll(compHandlers.keySet());
        keys.addAll(percHandlers.keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            StyleKey key = (StyleKey)iterator.next();
            ResolveHandler autoHandler = (ResolveHandler)autoHandlers.get(key);
            ResolveHandler compHandler = (ResolveHandler)compHandlers.get(key);
            ResolveHandler percHandler = (ResolveHandler)percHandlers.get(key);
            handlerList.add(new ResolveHandlerModule(key, autoHandler, compHandler, percHandler));
        }
        this.handlers = handlerList.toArray(new ResolveHandlerModule[handlerList.size()]);
        this.handlers = ResolveHandlerSorter.sort(this.handlers);
    }

    private HashMap loadModules(String configPrefix) {
        HashMap<StyleKey, ResolveHandler> handlers = new HashMap<StyleKey, ResolveHandler>();
        Configuration config = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator sit = config.findPropertyKeys(configPrefix);
        int length = configPrefix.length();
        while (sit.hasNext()) {
            String configkey = (String)sit.next();
            String name = configkey.substring(length).toLowerCase();
            StyleKey key = this.registry.findKeyByName(name);
            if (key == null) {
                Log.warn((Object)("Invalid stylekey for resolver: " + name));
                continue;
            }
            String c = config.getConfigProperty(configkey);
            ResolveHandler module = (ResolveHandler)ObjectUtilities.loadAndInstantiate((String)c, (Class)(class$org$jfree$layouting$layouter$style$resolver$ResolverFactory == null ? ResolverFactory.class$("org.jfree.layouting.layouter.style.resolver.ResolverFactory") : class$org$jfree$layouting$layouter$style$resolver$ResolverFactory), (Class)(class$org$jfree$layouting$layouter$style$resolver$ResolveHandler == null ? ResolverFactory.class$("org.jfree.layouting.layouter.style.resolver.ResolveHandler") : class$org$jfree$layouting$layouter$style$resolver$ResolveHandler));
            if (module != null) {
                handlers.put(key, module);
                continue;
            }
            Log.warn((Object)("Invalid resolver implementation: " + c));
        }
        return handlers;
    }

    public void performResolve(LayoutProcess process, LayoutElement node) {
        LayoutContext layoutContext = node.getLayoutContext();
        for (int i = 0; i < this.handlers.length; ++i) {
            ResolveHandler percValueHandler;
            ResolveHandler compValueHandler;
            ResolveHandlerModule handler = this.handlers[i];
            StyleKey key = handler.getKey();
            CSSValue value = layoutContext.getValue(key);
            ResolveHandler autoValueHandler = handler.getAutoValueHandler();
            if (autoValueHandler != null && value instanceof CSSAutoValue) {
                autoValueHandler.resolve(process, node, key);
            }
            if ((compValueHandler = handler.getComputedValueHandler()) != null) {
                compValueHandler.resolve(process, node, key);
            }
            if ((percValueHandler = handler.getPercentagesValueHandler()) == null) continue;
            percValueHandler.resolve(process, node, key);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

