/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.CSSCounterRule;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.selectors.CSSSelector;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.DocumentMetaNode;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.StyleRuleMatcher;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceException;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class SimpleStyleRuleMatcher
implements StyleRuleMatcher {
    private LayoutProcess layoutProcess;
    private ResourceManager resourceManager;
    private CSSStyleRule[] activeStyleRules;
    private CSSStyleRule[] activePseudoStyleRules;
    private CSSPageRule[] pageRules;
    private CSSCounterRule[] counterRules;
    private NamespaceCollection namespaces;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleSheet;

    public void initialize(LayoutProcess layoutProcess) {
        int i;
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.layoutProcess = layoutProcess;
        this.resourceManager = layoutProcess.getResourceManager();
        ArrayList pageRules = new ArrayList();
        ArrayList counterRules = new ArrayList();
        ArrayList<CSSStyleRule> styleRules = new ArrayList<CSSStyleRule>();
        DocumentContext dc = this.layoutProcess.getDocumentContext();
        this.namespaces = dc.getNamespaces();
        String[] nsUri = this.namespaces.getNamespaces();
        for (int i2 = 0; i2 < nsUri.length; ++i2) {
            ResourceKey baseKey;
            StyleSheet styleSheet;
            String uri = nsUri[i2];
            NamespaceDefinition nsDef = this.namespaces.getDefinition(uri);
            ResourceKey rawKey = nsDef.getDefaultStyleSheetLocation();
            if (rawKey == null || (styleSheet = this.parseStyleSheet(rawKey, baseKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext()))) == null) continue;
            Log.debug((Object)("Loaded stylesheet from " + rawKey + " for namespace " + nsDef.getURI()));
            this.addStyleRules(styleSheet, styleRules);
            this.addPageRules(styleSheet, pageRules);
            this.addCounterRules(styleSheet, counterRules);
        }
        int metaNodeCount = dc.getMetaNodeCount();
        for (i = 0; i < metaNodeCount; ++i) {
            DocumentMetaNode dmn = dc.getMetaNode(i);
            String type = (String)dmn.getMetaAttribute("type");
            if ("link".equals(type)) {
                this.handleLinkNode(dmn, styleRules, pageRules, counterRules);
                continue;
            }
            if (!"style".equals(type)) continue;
            this.handleStyleNode(dmn, styleRules, pageRules, counterRules);
        }
        this.activeStyleRules = styleRules.toArray(new CSSStyleRule[styleRules.size()]);
        this.pageRules = pageRules.toArray(new CSSPageRule[pageRules.size()]);
        this.counterRules = counterRules.toArray(new CSSCounterRule[counterRules.size()]);
        styleRules.clear();
        for (i = 0; i < this.activeStyleRules.length; ++i) {
            CSSStyleRule activeStyleRule = this.activeStyleRules[i];
            if (!this.isPseudoElementRule(activeStyleRule)) continue;
            styleRules.add(activeStyleRule);
        }
        this.activePseudoStyleRules = styleRules.toArray(new CSSStyleRule[styleRules.size()]);
    }

    private void handleLinkNode(DocumentMetaNode node, ArrayList styleRules, ArrayList pageRules, ArrayList counterRules) {
        try {
            Object href = node.getMetaAttribute("href");
            ResourceKey baseKey = DocumentContextUtility.getBaseResource(this.layoutProcess.getDocumentContext());
            ResourceKey derivedKey = baseKey == null ? this.resourceManager.createKey(href) : this.resourceManager.deriveKey(baseKey, String.valueOf(href));
            StyleSheet styleSheet = this.parseStyleSheet(derivedKey, null);
            if (styleSheet == null) {
                return;
            }
            this.addStyleRules(styleSheet, styleRules);
            this.addPageRules(styleSheet, pageRules);
            this.addCounterRules(styleSheet, counterRules);
        }
        catch (ResourceKeyCreationException e) {
            e.printStackTrace();
        }
    }

    private void handleStyleNode(DocumentMetaNode node, ArrayList styleRules, ArrayList pageRules, ArrayList counterRules) {
        Object content;
        Object style = node.getMetaAttribute("#pcdata");
        if (style == null && (content = node.getMetaAttribute("#content")) instanceof StyleSheet) {
            StyleSheet styleSheet = (StyleSheet)content;
            this.addStyleRules(styleSheet, styleRules);
            this.addPageRules(styleSheet, pageRules);
            this.addCounterRules(styleSheet, counterRules);
            return;
        }
        String styleText = String.valueOf(style);
        try {
            byte[] bytes = styleText.getBytes("UTF-8");
            ResourceKey rawKey = this.resourceManager.createKey((Object)bytes);
            ResourceKey baseKey = DocumentContextUtility.getBaseResource(this.layoutProcess.getDocumentContext());
            StyleSheet styleSheet = this.parseStyleSheet(rawKey, baseKey);
            if (styleSheet == null) {
                return;
            }
            this.addStyleRules(styleSheet, styleRules);
            this.addPageRules(styleSheet, pageRules);
            this.addCounterRules(styleSheet, counterRules);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ResourceKeyCreationException e) {
            e.printStackTrace();
        }
    }

    private void addCounterRules(StyleSheet styleSheet, ArrayList rules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addCounterRules(styleSheet.getStyleSheet(i), rules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            StyleRule rule = styleSheet.getRule(i);
            if (!(rule instanceof CSSCounterRule)) continue;
            CSSCounterRule drule = (CSSCounterRule)rule;
            rules.add(drule);
        }
    }

    private void addPageRules(StyleSheet styleSheet, ArrayList rules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addPageRules(styleSheet.getStyleSheet(i), rules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            StyleRule rule = styleSheet.getRule(i);
            if (!(rule instanceof CSSPageRule)) continue;
            CSSPageRule drule = (CSSPageRule)rule;
            rules.add(drule);
        }
    }

    private void addStyleRules(StyleSheet styleSheet, ArrayList activeStyleRules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addStyleRules(styleSheet.getStyleSheet(i), activeStyleRules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            StyleRule rule = styleSheet.getRule(i);
            if (!(rule instanceof CSSStyleRule)) continue;
            CSSStyleRule drule = (CSSStyleRule)rule;
            activeStyleRules.add(drule);
        }
    }

    private StyleSheet parseStyleSheet(ResourceKey key, ResourceKey context) {
        try {
            Resource resource = this.resourceManager.create(key, context, class$org$jfree$layouting$input$style$StyleSheet == null ? (class$org$jfree$layouting$input$style$StyleSheet = SimpleStyleRuleMatcher.class$("org.jfree.layouting.input.style.StyleSheet")) : class$org$jfree$layouting$input$style$StyleSheet);
            return (StyleSheet)resource.getResource();
        }
        catch (ResourceException e) {
            Log.info((Object)("Unable to parse StyleSheet: " + e.getLocalizedMessage()));
            return null;
        }
    }

    private boolean isPseudoElementRule(CSSStyleRule rule) {
        CSSSelector selector = rule.getSelector();
        if (selector == null) {
            return false;
        }
        if (selector.getSelectorType() != 0) {
            return false;
        }
        ConditionalSelector cs = (ConditionalSelector)selector;
        Condition condition = cs.getCondition();
        return condition.getConditionType() == 10;
    }

    public boolean isMatchingPseudoElement(LayoutElement element, String pseudo) {
        for (int i = 0; i < this.activePseudoStyleRules.length; ++i) {
            SimpleSelector simpleSelector;
            CSSStyleRule activeStyleRule = this.activePseudoStyleRules[i];
            CSSSelector selector = activeStyleRule.getSelector();
            ConditionalSelector cs = (ConditionalSelector)selector;
            Condition condition = cs.getCondition();
            AttributeCondition ac = (AttributeCondition)condition;
            if (!ObjectUtilities.equal((Object)ac.getValue(), (Object)pseudo) || !this.isMatch(element, (Selector)(simpleSelector = cs.getSimpleSelector()))) continue;
            return true;
        }
        return false;
    }

    public StyleRuleMatcher deriveInstance() {
        return this;
    }

    public CSSStyleRule[] getMatchingRules(LayoutElement element) {
        ArrayList<CSSStyleRule> retvals = new ArrayList<CSSStyleRule>();
        for (int i = 0; i < this.activeStyleRules.length; ++i) {
            CSSStyleRule activeStyleRule = this.activeStyleRules[i];
            CSSSelector selector = activeStyleRule.getSelector();
            if (selector == null || !this.isMatch(element, selector)) continue;
            retvals.add(activeStyleRule);
        }
        return retvals.toArray(new CSSStyleRule[retvals.size()]);
    }

    private boolean isMatch(LayoutElement node, Selector selector) {
        short selectorType = selector.getSelectorType();
        switch (selectorType) {
            case 1: {
                return true;
            }
            case 2: {
                return node.getParent() == null;
            }
            case 3: {
                NegativeSelector negativeSelector = (NegativeSelector)selector;
                return !this.isMatch(node, (Selector)negativeSelector);
            }
            case 12: {
                SiblingSelector silbSelect = (SiblingSelector)selector;
                return this.isSilblingMatch(node, silbSelect);
            }
            case 9: {
                LayoutContext layoutContext = node.getLayoutContext();
                return layoutContext.isPseudoElement();
            }
            case 4: {
                ElementSelector es = (ElementSelector)selector;
                LayoutContext layoutContext = node.getLayoutContext();
                String localName = es.getLocalName();
                if (localName != null && !localName.equals(layoutContext.getTagName())) {
                    return false;
                }
                String namespaceURI = es.getNamespaceURI();
                return namespaceURI == null || namespaceURI.equals(layoutContext.getNamespace());
            }
            case 11: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (!this.isMatch(node, (Selector)ds.getSimpleSelector())) {
                    return false;
                }
                LayoutElement parent = node.getParent();
                return this.isMatch(parent, ds.getAncestorSelector());
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (!this.isMatch(node, (Selector)ds.getSimpleSelector())) {
                    return false;
                }
                return this.isDescendantMatch(node, ds.getAncestorSelector());
            }
            case 0: {
                ConditionalSelector cs = (ConditionalSelector)selector;
                if (!this.evaluateCondition(node, cs.getCondition())) {
                    return false;
                }
                return this.isMatch(node, (Selector)cs.getSimpleSelector());
            }
        }
        return false;
    }

    private boolean evaluateCondition(LayoutElement node, Condition condition) {
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition cc = (CombinatorCondition)condition;
                return this.evaluateCondition(node, cc.getFirstCondition()) && this.evaluateCondition(node, cc.getSecondCondition());
            }
            case 1: {
                CombinatorCondition cc = (CombinatorCondition)condition;
                return this.evaluateCondition(node, cc.getFirstCondition()) || this.evaluateCondition(node, cc.getSecondCondition());
            }
            case 4: {
                AttributeCondition ac = (AttributeCondition)condition;
                LayoutContext layoutContext = node.getLayoutContext();
                String namespaceURI = ac.getNamespaceURI();
                if (namespaceURI == null) {
                    namespaceURI = layoutContext.getNamespace();
                }
                AttributeMap attributes = layoutContext.getAttributes();
                Object attr = attributes.getAttribute(namespaceURI, ac.getLocalName());
                if (ac.getValue() == null) {
                    return attr != null;
                }
                return ObjectUtilities.equal((Object)attr, (Object)ac.getValue());
            }
            case 9: {
                AttributeCondition ac = (AttributeCondition)condition;
                LayoutContext layoutContext = node.getLayoutContext();
                String namespace = layoutContext.getNamespace();
                if (namespace == null) {
                    return false;
                }
                NamespaceDefinition ndef = this.namespaces.getDefinition(namespace);
                if (ndef == null) {
                    return false;
                }
                String[] classAttribute = ndef.getClassAttribute(layoutContext.getTagName());
                for (int i = 0; i < classAttribute.length; ++i) {
                    String attr = classAttribute[i];
                    String htmlAttr = (String)layoutContext.getAttributes().getAttribute(namespace, attr);
                    if (!this.isOneOfAttributes(htmlAttr, ac.getValue())) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                AttributeCondition ac = (AttributeCondition)condition;
                LayoutContext layoutContext = node.getLayoutContext();
                AttributeMap attributes = layoutContext.getAttributes();
                Object id = attributes.getAttribute("http://www.w3.org/XML/1998/namespace", "id");
                return ObjectUtilities.equal((Object)ac.getValue(), (Object)id);
            }
            case 6: {
                AttributeCondition ac = (AttributeCondition)condition;
                LayoutContext layoutContext = node.getLayoutContext();
                Locale locale = layoutContext.getLanguage();
                String lang = locale.getLanguage();
                return this.isBeginHyphenAttribute(lang, ac.getValue());
            }
            case 2: {
                NegativeCondition nc = (NegativeCondition)condition;
                return !this.evaluateCondition(node, nc.getCondition());
            }
            case 7: {
                AttributeCondition ac = (AttributeCondition)condition;
                LayoutContext layoutContext = node.getLayoutContext();
                String attr = (String)layoutContext.getAttributes().getAttribute(ac.getNamespaceURI(), ac.getLocalName());
                return this.isOneOfAttributes(attr, ac.getValue());
            }
            case 10: {
                AttributeCondition ac = (AttributeCondition)condition;
                LayoutContext layoutContext = node.getLayoutContext();
                String pseudoClass = layoutContext.getPseudoElement();
                if (pseudoClass == null) {
                    return false;
                }
                return pseudoClass.equals(ac.getValue());
            }
        }
        return false;
    }

    private boolean isOneOfAttributes(String attrValue, String value) {
        if (attrValue == null) {
            return false;
        }
        if (attrValue.equals(value)) {
            return true;
        }
        StringTokenizer strTok = new StringTokenizer(attrValue);
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeginHyphenAttribute(String attrValue, String value) {
        if (attrValue == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        return attrValue.startsWith(value);
    }

    private boolean isDescendantMatch(LayoutElement node, Selector selector) {
        for (LayoutElement parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.isMatch(parent, selector)) continue;
            return true;
        }
        return false;
    }

    private boolean isSilblingMatch(LayoutElement node, SiblingSelector select) {
        for (LayoutElement pred = node.getPrevious(); pred != null; pred = pred.getPrevious()) {
            if (!this.isMatch(pred, (Selector)select)) continue;
            return true;
        }
        return false;
    }

    public CSSPageRule[] getPageRule(CSSValue pageName, PseudoPage[] pseudoPages) {
        CSSPageRule[] pageRules = this.pageRules;
        ArrayList<CSSPageRule> rules = new ArrayList<CSSPageRule>();
        for (int i = 0; i < pageRules.length; ++i) {
            CSSPageRule rule = pageRules[i];
            String rulePageName = rule.getName();
            if (rulePageName != null && !rulePageName.equals(pageName)) continue;
            String rulePseudoPage = rule.getPseudoPage();
            if (rulePseudoPage != null) {
                for (int j = 0; j < pseudoPages.length; ++j) {
                    PseudoPage pseudoPage = pseudoPages[j];
                    if (!pseudoPage.toString().equalsIgnoreCase(rulePseudoPage)) continue;
                    rules.add(rule);
                }
                continue;
            }
            rules.add(rule);
        }
        return rules.toArray(new CSSPageRule[rules.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

