/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.autovalue.box;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.text.BlockProgression;
import org.jfree.layouting.input.style.keys.text.Direction;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class FitPositionResolveHandler
implements ResolveHandler {
    private static final CSSNumericValue LEFT_TOP = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    private static final CSSNumericValue RIGHT_BOTTOM = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{TextStyleKeys.BLOCK_PROGRESSION, TextStyleKeys.DIRECTION};
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        boolean rightToLeft = Direction.RTL.equals(layoutContext.getValue(TextStyleKeys.DIRECTION));
        CSSValue blockProgression = layoutContext.getValue(TextStyleKeys.BLOCK_PROGRESSION);
        if (BlockProgression.TB.equals(blockProgression)) {
            if (rightToLeft) {
                layoutContext.setValue(key, new CSSValuePair(RIGHT_BOTTOM, LEFT_TOP));
            } else {
                layoutContext.setValue(key, new CSSValuePair(LEFT_TOP, LEFT_TOP));
            }
        } else if (BlockProgression.RL.equals(blockProgression)) {
            if (rightToLeft) {
                layoutContext.setValue(key, new CSSValuePair(LEFT_TOP, LEFT_TOP));
            } else {
                layoutContext.setValue(key, new CSSValuePair(RIGHT_BOTTOM, LEFT_TOP));
            }
        } else if (BlockProgression.LR.equals(blockProgression)) {
            if (rightToLeft) {
                layoutContext.setValue(key, new CSSValuePair(RIGHT_BOTTOM, RIGHT_BOTTOM));
            } else {
                layoutContext.setValue(key, new CSSValuePair(LEFT_TOP, LEFT_TOP));
            }
        }
    }
}

