/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed;

import java.util.HashMap;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public abstract class ConstantsResolveHandler
implements ResolveHandler {
    private static final StyleKey[] EMPTY_STYLE_KEYS = new StyleKey[0];
    private HashMap constants = new HashMap();
    private CSSValue fallback;

    protected ConstantsResolveHandler() {
    }

    public CSSValue getFallback() {
        return this.fallback;
    }

    protected void setFallback(CSSValue fallback) {
        this.fallback = fallback;
    }

    protected CSSValue lookupValue(CSSConstant value) {
        return (CSSValue)this.constants.get(value);
    }

    protected void addValue(CSSConstant constant, CSSValue value) {
        this.constants.put(constant, value);
    }

    protected void addNormalizeValue(CSSConstant constant) {
        this.constants.put(constant, constant);
    }

    public StyleKey[] getRequiredStyles() {
        return EMPTY_STYLE_KEYS;
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        CSSValue value = this.resolveValue(process, currentNode, key);
        if (value != null) {
            currentNode.getLayoutContext().setValue(key, value);
        }
    }

    protected CSSValue resolveValue(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSConstant)) {
            CSSValue fallback = this.getFallback();
            if (fallback != null) {
                return fallback;
            }
            return null;
        }
        CSSConstant constant = (CSSConstant)value;
        CSSValue resolvedValue = this.lookupValue(constant);
        if (resolvedValue != null) {
            return resolvedValue;
        }
        CSSValue fallback = this.getFallback();
        if (fallback != null) {
            return fallback;
        }
        return null;
    }
}

