/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;
import org.jfree.util.Log;

public abstract class ListOfConstantsResolveHandler
extends ConstantsResolveHandler {
    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        CSSValue value = currentNode.getLayoutContext().getValue(key);
        if (value == null) {
            return;
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        CSSValueList list = (CSSValueList)value;
        int length = list.getLength();
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            CSSValue item = list.getItem(i);
            if (!(item instanceof CSSConstant)) {
                this.resolveInvalidItem(process, currentNode, key, i);
                continue;
            }
            this.resolveItem(process, currentNode, key, i, (CSSConstant)item);
        }
    }

    protected void resolveInvalidItem(LayoutProcess process, LayoutElement currentNode, StyleKey key, int index) {
        Log.warn((Object)("Encountered invalid item in Style " + key + " at index " + index));
    }

    protected abstract boolean resolveItem(LayoutProcess var1, LayoutElement var2, StyleKey var3, int var4, CSSConstant var5);
}

