/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.border;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BackgroundRepeat;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.BackgroundSpecification;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class BackgroundRepeatResolveHandler
implements ResolveHandler {
    private static final CSSValuePair EMPTY_BACKGROUND_REPEAT = new CSSValuePair(BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT);

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        CSSValue value = currentNode.getLayoutContext().getValue(key);
        if (value == null) {
            return;
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        CSSValueList list = (CSSValueList)value;
        int length = list.getLength();
        if (length == 0) {
            return;
        }
        BackgroundSpecification backgroundSpecification = currentNode.getLayoutContext().getBackgroundSpecification();
        for (int i = 0; i < length; ++i) {
            CSSValue item = list.getItem(i);
            if (!(item instanceof CSSValuePair)) {
                backgroundSpecification.setBackgroundRepeat(i, EMPTY_BACKGROUND_REPEAT);
                continue;
            }
            CSSValuePair bvalue = (CSSValuePair)item;
            backgroundSpecification.setBackgroundRepeat(i, bvalue);
        }
    }
}

