/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.border;

import java.util.HashMap;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.border.BorderWidth;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class BorderWidthResolveHandler
extends ConstantsResolveHandler {
    private HashMap keyMapping = new HashMap();

    public BorderWidthResolveHandler() {
        this.keyMapping.put(BorderStyleKeys.BORDER_TOP_WIDTH, BorderStyleKeys.BORDER_TOP_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_LEFT_WIDTH, BorderStyleKeys.BORDER_LEFT_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_BOTTOM_WIDTH, BorderStyleKeys.BORDER_BOTTOM_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_RIGHT_WIDTH, BorderStyleKeys.BORDER_RIGHT_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_BREAK_WIDTH, BorderStyleKeys.BORDER_BREAK_STYLE);
        this.addValue(BorderWidth.THIN, CSSNumericValue.createValue(CSSNumericType.PT, 1.0));
        this.addValue(BorderWidth.MEDIUM, CSSNumericValue.createValue(CSSNumericType.PT, 3.0));
        this.addValue(BorderWidth.THICK, CSSNumericValue.createValue(CSSNumericType.PT, 5.0));
        this.setFallback(CSSNumericValue.ZERO_LENGTH);
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_STYLE, BorderStyleKeys.BORDER_LEFT_STYLE, BorderStyleKeys.BORDER_BOTTOM_STYLE, BorderStyleKeys.BORDER_RIGHT_STYLE, BorderStyleKeys.BORDER_BREAK_STYLE};
    }

    protected CSSValue resolveValue(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        StyleKey borderStyleKey = (StyleKey)this.keyMapping.get(key);
        if (borderStyleKey == null) {
            throw new IllegalArgumentException("This is not a valid key: " + key);
        }
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue borderStyle = layoutContext.getValue(borderStyleKey);
        if (BorderStyle.NONE.equals(borderStyle)) {
            return CSSNumericValue.ZERO_LENGTH;
        }
        CSSValue value = layoutContext.getValue(key);
        if (value instanceof CSSConstant) {
            return super.resolveValue(process, currentNode, key);
        }
        return value;
    }
}

