/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.color;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.color.CSSSystemColors;
import org.jfree.layouting.input.style.keys.color.ColorStyleKeys;
import org.jfree.layouting.input.style.keys.color.HtmlColors;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.util.ColorUtil;

public class ColorResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext style = currentNode.getLayoutContext();
        CSSValue value = style.getValue(key);
        if (value instanceof CSSColorValue) {
            return;
        }
        if (value instanceof CSSFunctionValue) {
            CSSFunctionValue functionValue = (CSSFunctionValue)value;
            StyleValueFunction function = FunctionFactory.getInstance().getStyleFunction(functionValue.getFunctionName());
            if (function == null) {
                value = HtmlColors.BLACK;
            } else {
                try {
                    value = function.evaluate(process, currentNode, functionValue);
                }
                catch (FunctionEvaluationException e) {
                    value = HtmlColors.BLACK;
                }
            }
            if (value instanceof CSSColorValue) {
                style.setValue(key, value);
                return;
            }
        }
        if (!(value instanceof CSSConstant)) {
            style.setValue(key, HtmlColors.BLACK);
            return;
        }
        if (CSSSystemColors.CURRENT_COLOR.equals(value)) {
            style.setValue(key, this.getCurrentColor(currentNode));
            return;
        }
        CSSValue c = ColorUtil.parseIdentColor(value.getCSSText());
        if (c != null) {
            style.setValue(key, c);
        } else {
            style.setValue(key, HtmlColors.BLACK);
        }
    }

    protected CSSColorValue getCurrentColor(LayoutElement currentNode) {
        LayoutContext layoutContext;
        CSSValue value;
        LayoutElement parent = currentNode.getParent();
        if (parent != null && (value = (layoutContext = parent.getLayoutContext()).getValue(ColorStyleKeys.COLOR)) instanceof CSSColorValue) {
            return (CSSColorValue)value;
        }
        return HtmlColors.BLACK;
    }
}

