/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class CounterResetResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BoxStyleKeys.DISPLAY_ROLE};
    }

    public void resolve(LayoutProcess process, LayoutElement element, StyleKey key) {
        LayoutContext layoutContext = element.getLayoutContext();
        CSSValue displayRole = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.NONE.equals(displayRole)) {
            return;
        }
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSValueList)) {
            return;
        }
        CSSValueList valueList = (CSSValueList)value;
        for (int i = 0; i < valueList.getLength(); ++i) {
            CSSValuePair counter;
            CSSValue counterName;
            CSSValue item = valueList.getItem(i);
            if (!(item instanceof CSSValuePair) || !((counterName = (counter = (CSSValuePair)item).getFirstValue()) instanceof CSSConstant)) continue;
            CSSValue counterValue = counter.getSecondValue();
            int counterIntValue = this.parseCounterValue(counterValue, element);
            element.resetCounter(counterName.getCSSText(), counterIntValue);
        }
    }

    private int parseCounterValue(CSSValue rawValue, LayoutElement element) {
        if (rawValue instanceof CSSNumericValue) {
            CSSNumericValue nval = (CSSNumericValue)rawValue;
            return (int)nval.getValue();
        }
        if (rawValue instanceof CSSAttrFunction) {
            CSSAttrFunction attrFunction = (CSSAttrFunction)rawValue;
            String attrName = attrFunction.getName();
            String attrNamespace = attrFunction.getNamespace();
            Object rawAttribute = element.getLayoutContext().getAttributes().getAttribute(attrNamespace, attrName);
            if (rawAttribute instanceof Number) {
                Number nAttr = (Number)rawAttribute;
                return nAttr.intValue();
            }
        }
        return 0;
    }
}

