/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import java.net.URL;
import java.util.ArrayList;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.ContentValues;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.ExternalContentToken;
import org.jfree.layouting.layouter.content.statics.ResourceContentToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.layouter.style.values.CSSRawValue;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;

public class XAlternateTextResolveHandler
implements ResolveHandler {
    private static final ContentToken[] DEFAULT_CONTENT = new ContentToken[0];

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET, ContentStyleKeys.COUNTER_INCREMENT, ContentStyleKeys.QUOTES, ContentStyleKeys.STRING_DEFINE};
    }

    public void resolve(LayoutProcess process, LayoutElement element, StyleKey key) {
        LayoutContext layoutContext = element.getLayoutContext();
        ContentSpecification contentSpecification = layoutContext.getContentSpecification();
        CSSValue value = layoutContext.getValue(key);
        if (value instanceof CSSConstant && ContentValues.NONE.equals(value)) {
            contentSpecification.setStrings(DEFAULT_CONTENT);
            return;
        }
        contentSpecification.setStrings(DEFAULT_CONTENT);
        if (value instanceof CSSAttrFunction) {
            ContentToken token = this.evaluateFunction((CSSFunctionValue)value, process, element);
            if (token == null) {
                return;
            }
            contentSpecification.setStrings(new ContentToken[]{token});
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        ArrayList<ContentToken> tokens = new ArrayList<ContentToken>();
        CSSValueList list = (CSSValueList)value;
        int size = list.getLength();
        block0: for (int i = 0; i < size; ++i) {
            CSSValueList sequence = (CSSValueList)list.getItem(i);
            for (int j = 0; j < sequence.getLength(); ++j) {
                CSSValue content = sequence.getItem(j);
                ContentToken token = this.createToken(process, element, content);
                if (token == null) {
                    tokens.clear();
                    continue block0;
                }
                tokens.add(token);
            }
        }
        ContentToken[] contents = tokens.toArray(new ContentToken[tokens.size()]);
        contentSpecification.setStrings(contents);
    }

    private ContentToken createToken(LayoutProcess process, LayoutElement element, CSSValue content) {
        if (content instanceof CSSStringValue) {
            CSSStringValue sval = (CSSStringValue)content;
            if (CSSStringType.STRING.equals(sval.getType())) {
                return new StaticTextToken(sval.getValue());
            }
            CSSFunctionValue function = new CSSFunctionValue("url", new CSSValue[]{sval});
            return this.evaluateFunction(function, process, element);
        }
        if (content instanceof CSSFunctionValue) {
            return this.evaluateFunction((CSSFunctionValue)content, process, element);
        }
        if (content instanceof CSSConstant && ContentValues.DOCUMENT_URL.equals(content)) {
            Object docUrl = process.getDocumentContext().getMetaAttribute("document-url");
            if (docUrl != null) {
                return new StaticTextToken(String.valueOf(docUrl));
            }
            ResourceKey baseKey = DocumentContextUtility.getBaseResource(process.getDocumentContext());
            ResourceManager resourceManager = DocumentContextUtility.getResourceManager(process.getDocumentContext());
            URL url = resourceManager.toURL(baseKey);
            if (url != null) {
                return new StaticTextToken(url.toExternalForm());
            }
            return null;
        }
        return null;
    }

    private ContentToken evaluateFunction(CSSFunctionValue function, LayoutProcess process, LayoutElement element) {
        StyleValueFunction styleFunction = FunctionFactory.getInstance().getStyleFunction(function.getFunctionName());
        try {
            CSSValue value = styleFunction.evaluate(process, element, function);
            if (value instanceof CSSResourceValue) {
                CSSResourceValue refValue = (CSSResourceValue)value;
                return new ResourceContentToken(refValue.getValue());
            }
            if (value instanceof CSSStringValue) {
                CSSStringValue strval = (CSSStringValue)value;
                return new StaticTextToken(strval.getValue());
            }
            if (value instanceof CSSRawValue) {
                CSSRawValue rawValue = (CSSRawValue)value;
                return new ExternalContentToken(rawValue.getValue());
            }
            return new StaticTextToken(value.getCSSText());
        }
        catch (FunctionEvaluationException e) {
            Log.debug((Object)("Evaluation failed " + (Object)((Object)e)));
            return null;
        }
    }
}

