/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.page;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageSizeFactory;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class PageSizeResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(PageStyleKeys.SIZE);
        String name = null;
        if (value instanceof CSSStringValue) {
            CSSStringValue sval = (CSSStringValue)value;
            name = sval.getValue();
        } else if (value instanceof CSSConstant) {
            name = value.toString();
        }
        PageSize ps = null;
        if (name != null) {
            ps = PageSizeFactory.getInstance().getPageSizeByName(name);
        }
        if (ps == null) {
            ps = process.getOutputMetaData().getDefaultPageSize();
        }
        CSSValuePair page = new CSSValuePair(CSSNumericValue.createPtValue(ps.getWidth()), CSSNumericValue.createPtValue(ps.getHeight()));
        layoutContext.setValue(PageStyleKeys.SIZE, page);
    }
}

