/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.text;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class TextOverflowEllipsisResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        CSSStringValue lineEllipsis = null;
        CSSStringValue blockEllipsis = null;
        if (value instanceof CSSValueList) {
            CSSValueList vlist = (CSSValueList)value;
            if (vlist.getLength() == 2) {
                lineEllipsis = this.filterString(vlist.getItem(0));
                blockEllipsis = this.filterString(vlist.getItem(1));
            } else if (vlist.getLength() == 1) {
                lineEllipsis = this.filterString(vlist.getItem(0));
                blockEllipsis = this.filterString(vlist.getItem(0));
            }
        }
        if (lineEllipsis == null) {
            lineEllipsis = new CSSStringValue(CSSStringType.STRING, "..");
        }
        if (blockEllipsis == null) {
            blockEllipsis = new CSSStringValue(CSSStringType.STRING, "..");
        }
        layoutContext.setValue(TextStyleKeys.X_BLOCK_TEXT_OVERFLOW_ELLIPSIS, blockEllipsis);
        layoutContext.setValue(TextStyleKeys.X_LINE_TEXT_OVERFLOW_ELLIPSIS, lineEllipsis);
    }

    private CSSStringValue filterString(CSSValue value) {
        if (!(value instanceof CSSStringValue)) {
            return null;
        }
        return (CSSStringValue)value;
    }
}

