/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.fonts;

import org.jfree.fonts.registry.FontMetrics;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class FontSizeAdjustResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_FAMILY, FontStyleKeys.FONT_EFFECT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_WEIGHT};
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSNumericValue)) {
            return;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (!CSSNumericType.NUMBER.equals(nval.getType())) {
            return;
        }
        LayoutElement parent = currentNode.getParent();
        if (parent == null) {
            return;
        }
        double adjustFactor = nval.getValue();
        FontSpecification fontSpecification = currentNode.getLayoutContext().getFontSpecification();
        FontMetrics fontMetrics = process.getOutputMetaData().getFontMetrics(fontSpecification);
        if (fontMetrics == null) {
            return;
        }
        double actualFontXHeight = fontMetrics.getXHeight();
        double fontSize = fontSpecification.getFontSize();
        double aspectRatio = actualFontXHeight / fontSize;
        double result = fontSize * (adjustFactor / aspectRatio);
        fontSpecification.setFontSize(result);
    }
}

