/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.line;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineHeight;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class LineHeightResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_SIZE_ADJUST};
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        double factor;
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (LineHeight.NONE.equals(value)) {
            this.handleNone(currentNode);
            return;
        }
        if (LineHeight.NORMAL.equals(value)) {
            this.handleNormal(currentNode);
            return;
        }
        if (!(value instanceof CSSNumericValue)) {
            this.handleNormal(currentNode);
            return;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (CSSValueResolverUtility.isLengthValue(nval)) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, nval);
            return;
        }
        if (nval.getType().equals(CSSNumericType.PERCENTAGE)) {
            factor = nval.getValue() / 100.0;
        } else if (nval.getType().equals(CSSNumericType.NUMBER)) {
            factor = nval.getValue();
        } else {
            this.handleNormal(currentNode);
            return;
        }
        double fontSize = layoutContext.getFontSpecification().getFontSize();
        layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * factor));
    }

    private void handleNormal(LayoutElement currentNode) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        double fontSize = layoutContext.getFontSpecification().getFontSize();
        if (fontSize < 10.0) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * 1.2));
        } else if (fontSize < 24.0) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * 1.1));
        } else {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize * 1.05));
        }
    }

    private void handleNone(LayoutElement currentNode) {
        LayoutElement parent = currentNode.getParent();
        LayoutContext layoutContext = currentNode.getLayoutContext();
        double fontSize = parent == null ? layoutContext.getFontSpecification().getFontSize() : parent.getLayoutContext().getFontSpecification().getFontSize();
        layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, fontSize));
    }
}

