/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.text;

import org.jfree.fonts.registry.FontMetrics;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class LetterSpacingResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_FAMILY, FontStyleKeys.FONT_EFFECT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_WEIGHT};
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        FontMetrics fm = process.getOutputMetaData().getFontMetrics(fontSpecification);
        if (fm == null) {
            layoutContext.setValue(TextStyleKeys.X_MIN_LETTER_SPACING, CSSNumericValue.ZERO_LENGTH);
            layoutContext.setValue(TextStyleKeys.X_MAX_LETTER_SPACING, CSSNumericValue.ZERO_LENGTH);
            layoutContext.setValue(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, CSSNumericValue.ZERO_LENGTH);
            return;
        }
        double width = fm.getCharWidth(32);
        CSSNumericValue percentageBase = CSSNumericValue.createValue(CSSNumericType.PT, width);
        CSSNumericValue min = CSSValueResolverUtility.getLength(this.resolveValue(layoutContext, TextStyleKeys.X_MIN_LETTER_SPACING), percentageBase);
        CSSNumericValue max = CSSValueResolverUtility.getLength(this.resolveValue(layoutContext, TextStyleKeys.X_MAX_LETTER_SPACING), percentageBase);
        CSSNumericValue opt = CSSValueResolverUtility.getLength(this.resolveValue(layoutContext, TextStyleKeys.X_OPTIMUM_LETTER_SPACING), percentageBase);
        layoutContext.setValue(TextStyleKeys.X_MIN_LETTER_SPACING, min);
        layoutContext.setValue(TextStyleKeys.X_MAX_LETTER_SPACING, max);
        layoutContext.setValue(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, opt);
    }

    private CSSNumericValue resolveValue(LayoutContext style, StyleKey key) {
        CSSValue value = style.getValue(key);
        if (!(value instanceof CSSNumericValue)) {
            return CSSNumericValue.ZERO_LENGTH;
        }
        return (CSSNumericValue)value;
    }
}

