/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import org.jfree.fonts.awt.AWTFontRegistry;
import org.jfree.fonts.registry.DefaultFontStorage;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;
import org.jfree.layouting.modules.output.graphics.GraphicsContentInterceptor;
import org.jfree.layouting.modules.output.graphics.GraphicsOutputProcessorMetaData;
import org.jfree.layouting.modules.output.graphics.LogicalPageDrawable;
import org.jfree.layouting.modules.output.graphics.PhysicalPageDrawable;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.AbstractPageableProcessor;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PageFlowSelector;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;
import org.jfree.util.Configuration;

public class GraphicsOutputProcessor
extends AbstractPageableProcessor {
    private OutputProcessorMetaData metaData;
    private GraphicsContentInterceptor interceptor;

    public GraphicsOutputProcessor(Configuration configuration) {
        super(configuration);
        DefaultFontStorage fontStorage = new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
        this.metaData = new GraphicsOutputProcessorMetaData((FontStorage)fontStorage, false);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public GraphicsContentInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(GraphicsContentInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    protected PageFlowSelector getFlowSelector() {
        return this.getInterceptor();
    }

    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) {
        PhysicalPageBox page = pageGrid.getPage(row, col);
        LogicalPageDrawable drawable = new LogicalPageDrawable(logicalPage);
        PhysicalPageDrawable pageDrawable = new PhysicalPageDrawable(drawable, page);
        this.interceptor.processPhysicalPage(pageKey, pageDrawable);
    }

    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) {
        LogicalPageDrawable drawable = new LogicalPageDrawable(logicalPage);
        this.interceptor.processLogicalPage(key, drawable);
    }
}

