/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.layouting.input.style.keys.color.ColorStyleKeys;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.modules.output.graphics.PageDrawable;
import org.jfree.layouting.output.pageable.BorderShapeFactory;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.text.Glyph;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.jfree.ui.Drawable;

public class LogicalPageDrawable
implements PageDrawable {
    private static final boolean OUTLINE_MODE = false;
    private LogicalPageBox rootBox;
    private PageFormat pageFormat;
    private double width;
    private double height;

    public LogicalPageDrawable(LogicalPageBox rootBox) {
        this.rootBox = rootBox;
        this.width = (float)rootBox.getPageWidth() / 1000.0f;
        this.height = (float)rootBox.getPageHeight() / 1000.0f;
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, this.width, this.height);
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(paper);
    }

    public PageFormat getPageFormat() {
        return (PageFormat)this.pageFormat.clone();
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)this.width, (int)this.height);
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        g2.setPaint(Color.white);
        g2.fill(area);
        this.drawBox(g2, this.rootBox.getHeaderArea(), 0);
        this.drawBox(g2, this.rootBox, 0);
        this.drawBox(g2, this.rootBox.getFooterArea(), 0);
    }

    private void drawDebugBox(Graphics2D g2, RenderBox box) {
        if (box instanceof TableCellRenderBox) {
            g2.setPaint(Color.yellow);
        } else if (box instanceof TableRowRenderBox) {
            g2.setPaint(Color.green);
        } else if (box instanceof TableSectionRenderBox) {
            g2.setPaint(Color.red);
        } else if (box instanceof TableRenderBox) {
            g2.setPaint(Color.blue);
        } else if (box instanceof ParagraphRenderBox) {
            g2.setPaint(Color.magenta);
        } else if (box instanceof ParagraphPoolBox) {
            g2.setPaint(Color.orange);
        } else {
            g2.setPaint(Color.lightGray);
        }
        int x = (int)(box.getX() / 1000L);
        int y = (int)(box.getY() / 1000L);
        int w = (int)(box.getWidth() / 1000L);
        int h = (int)(box.getHeight() / 1000L);
        g2.drawRect(x, y, w, h);
    }

    public void drawBox(Graphics2D g2, RenderBox box, int level) {
        BorderShapeFactory borderShapeFactory = new BorderShapeFactory(box);
        borderShapeFactory.generateBorder(g2);
        for (RenderNode childs = box.getFirstChild(); childs != null; childs = childs.getNext()) {
            if (childs instanceof RenderBox) {
                this.drawBox(g2, (RenderBox)childs, level + 1);
                continue;
            }
            if (childs instanceof RenderableText) {
                this.drawText(g2, (RenderableText)childs);
                continue;
            }
            if (!(childs instanceof RenderableReplacedContent)) continue;
            this.drawReplacedContent(g2, (RenderableReplacedContent)childs);
        }
    }

    private void drawReplacedContent(Graphics2D g2, RenderableReplacedContent content) {
        Object o = content.getRawObject();
        if (o instanceof Image) {
            int x = (int)StrictGeomUtility.toExternalValue(content.getX());
            int y = (int)StrictGeomUtility.toExternalValue(content.getY());
            int width = (int)StrictGeomUtility.toExternalValue(content.getWidth());
            int height = (int)StrictGeomUtility.toExternalValue(content.getHeight());
            g2.drawImage((Image)o, x, y, width, height, null);
        } else if (o instanceof Drawable) {
            double x = (int)StrictGeomUtility.toExternalValue(content.getX());
            double y = (int)StrictGeomUtility.toExternalValue(content.getY());
            double width = (int)StrictGeomUtility.toExternalValue(content.getWidth());
            double height = (int)StrictGeomUtility.toExternalValue(content.getHeight());
            Drawable d = (Drawable)o;
            Graphics2D g2Clone = (Graphics2D)g2.create();
            d.draw(g2Clone, (Rectangle2D)new Rectangle2D.Double(x, y, width, height));
            g2Clone.dispose();
        }
    }

    private void drawText(Graphics2D g2, RenderableText renderableText) {
        Glyph[] gs = renderableText.getGlyphs();
        long posX = renderableText.getX();
        long posY = renderableText.getY();
        long runningPos = posX;
        LayoutContext layoutContext = renderableText.getLayoutContext();
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        int style = 0;
        if (fontSpecification.getFontWeight() > 400) {
            style |= 1;
        }
        if (fontSpecification.isItalic() || fontSpecification.isOblique()) {
            style |= 2;
        }
        CSSColorValue cssColor = (CSSColorValue)layoutContext.getValue(ColorStyleKeys.COLOR);
        g2.setColor(cssColor);
        g2.setFont(new Font(fontSpecification.getFontFamily(), style, (int)fontSpecification.getFontSize()));
        int length = renderableText.getOffset() + renderableText.getLength();
        for (int i = renderableText.getOffset(); i < length; ++i) {
            Glyph g = gs[i];
            g2.drawString(LogicalPageDrawable.glpyhToString(g), (float)runningPos / 1000.0f, (float)(posY + (long)g.getBaseLine()) / 1000.0f);
            runningPos += (long)g.getWidth();
        }
    }

    public static String glpyhToString(Glyph g) {
        StringBuffer b = new StringBuffer();
        b.append((char)(0xFFFF & g.getCodepoint()));
        int[] extraCPs = g.getExtraChars();
        for (int i = 0; i < extraCPs.length; ++i) {
            b.append(", ");
            int extraCP = extraCPs[i];
            b.append(extraCP);
        }
        return b.toString();
    }
}

