/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.layouting.modules.output.graphics.LogicalPageDrawable;
import org.jfree.layouting.modules.output.graphics.PageDrawable;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;
import org.jfree.layouting.util.geom.StrictGeomUtility;

public class PhysicalPageDrawable
implements PageDrawable {
    private LogicalPageDrawable pageDrawable;
    private PageFormat pageFormat;
    private long globalX;
    private long globalY;

    public PhysicalPageDrawable(LogicalPageDrawable pageDrawable, PhysicalPageBox page) {
        this.pageDrawable = pageDrawable;
        this.pageFormat = new PageFormat();
        this.globalX = page.getGlobalX();
        this.globalY = page.getGlobalY();
        if (page.getWidth() < page.getHeight()) {
            Paper p = new Paper();
            p.setSize(StrictGeomUtility.toExternalValue(page.getWidth()), StrictGeomUtility.toExternalValue(page.getHeight()));
            p.setImageableArea(StrictGeomUtility.toExternalValue(page.getImageableX()), StrictGeomUtility.toExternalValue(page.getImageableY()), StrictGeomUtility.toExternalValue(page.getImageableWidth()), StrictGeomUtility.toExternalValue(page.getImageableHeight()));
            this.pageFormat.setPaper(p);
            this.pageFormat.setOrientation(1);
        } else {
            Paper p = new Paper();
            p.setSize(StrictGeomUtility.toExternalValue(page.getHeight()), StrictGeomUtility.toExternalValue(page.getWidth()));
            p.setImageableArea(StrictGeomUtility.toExternalValue(page.getImageableY()), StrictGeomUtility.toExternalValue(page.getImageableX()), StrictGeomUtility.toExternalValue(page.getImageableHeight()), StrictGeomUtility.toExternalValue(page.getImageableWidth()));
            this.pageFormat.setPaper(p);
            this.pageFormat.setOrientation(0);
        }
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        g2.translate(this.globalX, this.globalY);
        g2.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
        this.pageDrawable.draw(g2, new Rectangle2D.Double(0.0, 0.0, this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight()));
        g2.dispose();
    }
}

