/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import java.util.ArrayList;
import org.jfree.layouting.modules.output.html.URLRewriteException;
import org.jfree.layouting.modules.output.html.URLRewriter;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentLocation;

public class SingleRepositoryURLRewriter
implements URLRewriter {
    public String rewrite(ContentEntity sourceDocument, ContentEntity dataEntity) throws URLRewriteException {
        ContentLocation location;
        if (!sourceDocument.getRepository().equals(dataEntity.getRepository())) {
            throw new URLRewriteException("Content and data repository must be the same.");
        }
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add(dataEntity.getName());
        for (location = dataEntity.getParent(); location != null; location = location.getParent()) {
            entityNames.add(location.getName());
        }
        ArrayList<String> contentNames = new ArrayList<String>();
        for (location = sourceDocument.getParent(); location != null; location = location.getParent()) {
            contentNames.add(location.getName());
        }
        while (!contentNames.isEmpty() && !entityNames.isEmpty()) {
            String lastEntity = (String)entityNames.get(entityNames.size() - 1);
            String lastContent = (String)contentNames.get(contentNames.size() - 1);
            if (!lastContent.equals(lastEntity)) break;
            entityNames.remove(entityNames.size() - 1);
            contentNames.remove(contentNames.size() - 1);
        }
        StringBuffer b = new StringBuffer();
        for (int i = entityNames.size() - 1; i >= 0; --i) {
            String name = (String)entityNames.get(i);
            b.append(name);
            if (i == 0) continue;
            b.append("/");
        }
        return b.toString();
    }
}

