/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.layouting.LibLayoutInfo;
import org.jfree.layouting.modules.output.graphics.LogicalPageDrawable;
import org.jfree.layouting.modules.output.graphics.PhysicalPageDrawable;
import org.jfree.layouting.modules.output.pdf.itext.BaseFontSupport;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class PdfDocumentWriter {
    private static final String CREATOR = LibLayoutInfo.getInstance().getName() + " version " + LibLayoutInfo.getInstance().getVersion();
    private static final byte[] PDF_PASSWORD_PAD = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private Document document;
    private OutputStream out;
    private PdfWriter writer;
    private boolean awaitOpenDocument;
    private Configuration config;
    private BaseFontSupport fontSupport;

    public PdfDocumentWriter(Configuration config, OutputStream out) {
        this.out = out;
        this.config = config;
        this.fontSupport = new BaseFontSupport();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void open() throws DocumentException {
        this.setDocument(new Document());
        this.writer = PdfWriter.getInstance((Document)this.getDocument(), (OutputStream)this.out);
        this.writer.setLinearPageMode();
        char version = this.getVersion();
        this.writer.setPdfVersion(version);
        String encrypt = this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.Encryption");
        if (encrypt != null && (encrypt.equals("128bit") || encrypt.equals("40bit"))) {
            String userpassword = this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.UserPassword");
            String ownerpassword = this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.OwnerPassword");
            byte[] userpasswordbytes = DocWriter.getISOBytes((String)userpassword);
            byte[] ownerpasswordbytes = DocWriter.getISOBytes((String)ownerpassword);
            if (ownerpasswordbytes == null) {
                ownerpasswordbytes = PDF_PASSWORD_PAD;
            }
            this.writer.setEncryption(userpasswordbytes, ownerpasswordbytes, this.getPermissions(), encrypt.equals("128bit"));
        }
        this.getDocument().addCreator(CREATOR);
        this.getDocument().addCreationDate();
        this.awaitOpenDocument = true;
    }

    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) throws DocumentException {
        PhysicalPageBox page = pageGrid.getPage(row, col);
        float width = (float)StrictGeomUtility.toExternalValue(page.getWidth());
        float height = (float)StrictGeomUtility.toExternalValue(page.getHeight());
        Rectangle pageSize = new Rectangle(width, height);
        float marginLeft = (float)StrictGeomUtility.toExternalValue(page.getImageableX());
        float marginRight = (float)StrictGeomUtility.toExternalValue(page.getWidth() - page.getImageableWidth() - page.getImageableX());
        float marginTop = (float)StrictGeomUtility.toExternalValue(page.getImageableY());
        float marginBottom = (float)StrictGeomUtility.toExternalValue(page.getHeight() - page.getImageableHeight() - page.getImageableY());
        this.getDocument().setPageSize(pageSize);
        this.getDocument().setMargins(marginLeft, marginRight, marginTop, marginBottom);
        if (this.awaitOpenDocument) {
            this.getDocument().open();
        }
        Graphics2D graphics = this.writer.getDirectContent().createGraphics(width, height, (FontMapper)this.fontSupport);
        LogicalPageDrawable logicalPageDrawable = new LogicalPageDrawable(logicalPage);
        PhysicalPageDrawable drawable = new PhysicalPageDrawable(logicalPageDrawable, page);
        drawable.draw(graphics, new Rectangle2D.Double(0.0, 0.0, width, height));
        graphics.dispose();
        this.getDocument().newPage();
    }

    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) throws DocumentException {
        float width = (float)StrictGeomUtility.toExternalValue(logicalPage.getPageWidth());
        float height = (float)StrictGeomUtility.toExternalValue(logicalPage.getPageHeight());
        Rectangle pageSize = new Rectangle(width, height);
        this.getDocument().setPageSize(pageSize);
        this.getDocument().setMargins(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.awaitOpenDocument) {
            this.getDocument().open();
        }
        Graphics2D graphics = this.writer.getDirectContent().createGraphics(width, height, (FontMapper)this.fontSupport);
        LogicalPageDrawable logicalPageDrawable = new LogicalPageDrawable(logicalPage);
        logicalPageDrawable.draw(graphics, new Rectangle2D.Double(0.0, 0.0, width, height));
        graphics.dispose();
        this.getDocument().newPage();
    }

    public void close() {
        this.getDocument().close();
        this.fontSupport.close();
        try {
            this.out.flush();
        }
        catch (IOException e) {
            Log.info((Object)"Flushing the PDF-Export-Stream failed.");
        }
        this.document = null;
        this.writer = null;
    }

    private char getVersion() {
        String version = this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.Version");
        if (version == null) {
            return '4';
        }
        if (version.length() < 3) {
            Log.warn((Object)"PDF version specification is invalid, using default version '1.4'.");
            return '4';
        }
        char retval = version.charAt(2);
        if (retval < '2' || retval > '9') {
            Log.warn((Object)"PDF version specification is invalid, using default version '1.4'.");
            return '4';
        }
        return retval;
    }

    private int getPermissions() {
        String printLevel = this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.PrintLevel");
        boolean allowPrinting = !"none".equals(printLevel);
        boolean allowDegradedPrinting = "degraded".equals(printLevel);
        boolean allowModifyContents = "true".equals(this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.AllowModifyContents"));
        boolean allowModifyAnn = "true".equals(this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.AllowModifyAnnotations"));
        boolean allowCopy = "true".equals(this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.AllowCopy"));
        boolean allowFillIn = "true".equals(this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.AllowFillIn"));
        boolean allowScreenReaders = "true".equals(this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.AllowScreenReader"));
        boolean allowAssembly = "true".equals(this.config.getConfigProperty("org.jfree.layouting.modules.output.pdf.security.AllowAssembly"));
        int permissions = 0;
        if (allowPrinting) {
            permissions |= 0x804;
        }
        if (allowModifyContents) {
            permissions |= 8;
        }
        if (allowModifyAnn) {
            permissions |= 0x20;
        }
        if (allowCopy) {
            permissions |= 0x10;
        }
        if (allowFillIn) {
            permissions |= 0x100;
        }
        if (allowScreenReaders) {
            permissions |= 0x200;
        }
        if (allowAssembly) {
            permissions |= 0x400;
        }
        if (allowDegradedPrinting) {
            permissions |= 4;
        }
        return permissions;
    }
}

