/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.pdf;

import java.io.OutputStream;
import org.jfree.fonts.awt.AWTFontRegistry;
import org.jfree.fonts.registry.DefaultFontStorage;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.modules.output.pdf.PdfDocumentWriter;
import org.jfree.layouting.modules.output.pdf.PdfOutputProcessorMetaData;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.AbstractPageableProcessor;
import org.jfree.layouting.output.pageable.AllPageFlowSelector;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PageFlowSelector;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.util.Configuration;

public class PdfOutputProcessor
extends AbstractPageableProcessor {
    private PdfOutputProcessorMetaData metaData;
    private PageFlowSelector flowSelector;
    private OutputStream outputStream;
    private PdfDocumentWriter writer;

    public PdfOutputProcessor(Configuration configuration, OutputStream outputStream) {
        super(configuration);
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.outputStream = outputStream;
        this.flowSelector = new AllPageFlowSelector();
        DefaultFontStorage fontStorage = new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
        this.metaData = new PdfOutputProcessorMetaData((FontStorage)fontStorage);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public PageFlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(PageFlowSelector flowSelector) {
        if (flowSelector == null) {
            throw new NullPointerException();
        }
        this.flowSelector = flowSelector;
    }

    public void processDocumentMetaData(DocumentContext documentContext) {
        super.processDocumentMetaData(documentContext);
    }

    protected void processingContentFinished() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) {
        try {
            if (this.writer == null) {
                this.writer = new PdfDocumentWriter(this.getConfiguration(), this.outputStream);
                this.writer.open();
            }
            this.writer.processPhysicalPage(pageGrid, logicalPage, row, col, pageKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) {
        try {
            if (this.writer == null) {
                this.writer = new PdfDocumentWriter(this.getConfiguration(), this.outputStream);
                this.writer.open();
            }
            this.writer.processLogicalPage(key, logicalPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

