/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.pdf.itext;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.truetype.TrueTypeFontRecord;
import org.jfree.fonts.truetype.TrueTypeFontRegistry;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.modules.output.pdf.itext.MinimalFontRecord;
import org.jfree.util.HashNMap;
import org.jfree.util.Log;
import org.jfree.util.StringUtils;

public final class BaseFontFactory
extends DefaultFontMapper {
    public static final String GC_AFTER_REGISTER = "org.jfree.layouting.modules.output.pdf.itext.GCAfterRegister";
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();
    private final Properties notEmbeddedFonts;
    private final Properties fontsByName = new Properties();
    private boolean initialized;
    private Properties confirmedFiles;
    private TrueTypeFontRegistry registry;

    public BaseFontFactory() {
        this.notEmbeddedFonts = new Properties();
        this.registry = new TrueTypeFontRegistry();
    }

    public synchronized void registerDefaultFontPath(String encoding) {
        HashNMap knownFonts = new HashNMap();
        Properties seenFiles = new Properties();
        this.confirmedFiles = new Properties();
        this.registry.initialize();
        if (encoding.equals("Identity-H") || encoding.equals("Identity-V")) {
            encoding = "UTF-16";
        }
        String osname = this.safeSystemGetProperty("os.name", "<protected by system security>");
        String jrepath = this.safeSystemGetProperty("java.home", ".");
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        Log.debug((Object)("Running on operating system: " + osname));
        Log.debug((Object)("Character encoding used as default: " + encoding));
        if (this.safeSystemGetProperty("mrj.version", null) != null) {
            String userhome = this.safeSystemGetProperty("user.home", ".");
            Log.debug((Object)"Detected MacOS (Property 'mrj.version' is present.");
            this.registerFontPath(new File(userhome + "/Library/Fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/Library/Fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/Network/Library/Fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/System/Library/Fonts"), encoding, knownFonts, seenFiles);
        } else if (StringUtils.startsWithIgnoreCase((String)osname, (String)"windows")) {
            this.registerWindowsFontPath(encoding, knownFonts, seenFiles);
        } else {
            Log.debug((Object)"Assuming unix like file structures");
            this.registerFontPath(new File("/usr/X11R6/lib/X11/fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/usr/share/fonts"), encoding, knownFonts, seenFiles);
        }
        this.registerFontPath(new File(jrepath, "lib" + fs + "fonts"), encoding, knownFonts, seenFiles);
        Log.info((Object)"Completed font registration.");
        this.initialized = true;
    }

    private String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    private void registerWindowsFontPath(String encoding, HashNMap knownFonts, Properties seenFiles) {
        Log.debug((Object)"Found windows in os name, assuming DOS/Win32 structures");
        String fontPath = null;
        String windirs = this.safeSystemGetProperty("java.library.path", null);
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        if (windirs != null) {
            StringTokenizer strtok = new StringTokenizer(windirs, this.safeSystemGetProperty("path.separator", File.pathSeparator));
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (!StringUtils.endsWithIgnoreCase((String)token, (String)"System32")) continue;
                int lastBackslash = token.lastIndexOf(fs);
                fontPath = token.substring(0, lastBackslash) + fs + "Fonts";
                break;
            }
        }
        Log.debug((Object)("Fonts located in \"" + fontPath + "\""));
        if (fontPath != null) {
            File file = new File(fontPath);
            this.registerFontPath(file, encoding, knownFonts, seenFiles);
        }
    }

    public synchronized void registerFontPath(File file, String encoding) {
        this.registerFontPath(file, encoding, new HashNMap(), new Properties());
        this.registry.registerFontPath(file);
    }

    private synchronized void registerFontPath(File file, String encoding, HashNMap knownFonts, Properties seenFiles) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            File[] files = file.listFiles(FONTPATHFILTER);
            for (int i = 0; i < files.length; ++i) {
                File currentFile = files[i];
                if (currentFile.isDirectory()) {
                    this.registerFontPath(currentFile, encoding, knownFonts, seenFiles);
                    continue;
                }
                String fileName = currentFile.toString();
                String cachedAccessTime = seenFiles.getProperty(fileName);
                String newAccessTime = String.valueOf(currentFile.lastModified() + "," + currentFile.length());
                if (!newAccessTime.equals(cachedAccessTime) || !this.notEmbeddedFonts.containsKey(fileName)) {
                    this.registerFontFile(fileName, encoding);
                    continue;
                }
                Iterator it = knownFonts.getAll((Object)fileName);
                while (it.hasNext()) {
                    String fontName = (String)it.next();
                    this.fontsByName.put(fontName, fileName);
                }
                this.confirmedFiles.put(fileName, newAccessTime);
            }
        }
        if ("true".equals(LibLayoutBoot.getInstance().getGlobalConfig().getConfigProperty(GC_AFTER_REGISTER, "true"))) {
            System.gc();
        }
    }

    public synchronized void registerFontFile(String filename, String encoding) {
        File file;
        if (filename.toLowerCase().endsWith(".ttf") || filename.toLowerCase().endsWith(".ttc") || filename.toLowerCase().endsWith(".otf")) {
            try {
                this.registry.registerFontFile(new File(filename));
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        if ((filename.toLowerCase().endsWith(".afm") || filename.toLowerCase().endsWith(".pfm")) && (file = new File(filename)).exists() && file.isFile() && file.canRead()) {
            String newAccessTime = String.valueOf(file.lastModified() + "," + file.length());
            this.confirmedFiles.put(filename, newAccessTime);
            try {
                this.addFont(filename, encoding);
            }
            catch (Exception e) {
                Log.warn((Object)new Log.SimpleMessage("Font ", (Object)filename, (Object)" is invalid. Message:", (Object)e.getMessage()));
                this.notEmbeddedFonts.setProperty(filename, "false");
            }
        }
    }

    private void addFont(String font, String encoding) throws DocumentException, IOException {
        BaseFont bfont;
        if (this.fontsByName.containsValue(font)) {
            return;
        }
        String filePfbName = font.substring(0, font.length() - 3) + "pfb";
        File filePfb = new File(filePfbName);
        boolean embedded = true;
        if (!(filePfb.exists() && filePfb.isFile() && filePfb.canRead())) {
            Log.warn((Object)("Cannot embedd font: " + filePfb + " is missing for " + font));
            embedded = false;
        }
        try {
            bfont = BaseFont.createFont((String)font, (String)encoding, (boolean)embedded, (boolean)false, null, null);
        }
        catch (DocumentException de) {
            if (!embedded) {
                throw de;
            }
            bfont = BaseFont.createFont((String)font, (String)encoding, (boolean)false, (boolean)false, null, null);
            embedded = false;
            Log.info((Object)new Log.SimpleMessage("Font ", (Object)font, (Object)"  cannot be used as embedded font due to licensing restrictions (PFB)."));
        }
        String embeddedText = String.valueOf(embedded);
        String[][] fi = bfont.getFullFontName();
        for (int i = 0; i < fi.length; ++i) {
            String[] ffi = fi[i];
            String knownFontEmbeddedState = this.notEmbeddedFonts.getProperty(font, "false");
            String logicalFontname = ffi[3];
            this.notEmbeddedFonts.setProperty(font, embeddedText);
            if (this.fontsByName.containsKey(logicalFontname) && ("true".equals(knownFontEmbeddedState) || embeddedText.equals(knownFontEmbeddedState))) continue;
            this.fontsByName.setProperty(logicalFontname, font);
            Log.debug((Object)new Log.SimpleMessage("Registered font (primary name):", (Object)logicalFontname, (Object)"; embedded=", (Object)embeddedText, (Object)new Log.SimpleMessage(", file=", (Object)font)));
        }
        String[][] afi = bfont.getFamilyFontName();
        for (int i = 0; i < afi.length; ++i) {
            String[] strings = afi[i];
            Log.debug((Object)new Log.SimpleMessage("Registered font (alternate name):", (Object)strings[3], (Object)"; embedded=", (Object)embeddedText, (Object)new Log.SimpleMessage(", file=", (Object)font)));
            this.fontsByName.setProperty(strings[3], font);
        }
    }

    public Iterator getRegisteredFonts() {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(this.fontsByName.keySet());
        treeSet.addAll(Arrays.asList(this.registry.getRegisteredFamilies()));
        return treeSet.iterator();
    }

    public FontRecord getFontForName(String font, boolean bold, boolean italics) {
        TrueTypeFontRecord ttfRecord;
        String retval = this.fontsByName.getProperty(font);
        if (retval != null) {
            boolean embedded = "true".equalsIgnoreCase(this.notEmbeddedFonts.getProperty(retval, "false"));
            return new MinimalFontRecord(font, retval, bold, italics, embedded);
        }
        FontFamily family = this.registry.getFontFamily(font);
        if (family == null) {
            return null;
        }
        FontRecord record = family.getFontRecord(bold, italics);
        if (record instanceof TrueTypeFontRecord && (ttfRecord = (TrueTypeFontRecord)record).isNonWindows()) {
            return null;
        }
        return record;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private static class FontPathFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            return StringUtils.endsWithIgnoreCase((String)name, (String)".afm") || StringUtils.endsWithIgnoreCase((String)name, (String)".pfm");
        }
    }
}

