/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.pdf.itext;

import com.lowagie.text.pdf.BaseFont;
import java.util.Map;
import org.jfree.resourceloader.CompoundResource;
import org.jfree.resourceloader.DependencyCollector;
import org.jfree.resourceloader.FactoryParameterKey;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceException;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;

public class BaseFontResourceFactory
implements ResourceFactory {
    public static final FactoryParameterKey FONTNAME = new FactoryParameterKey("filename");
    public static final FactoryParameterKey ENCODING = new FactoryParameterKey("encoding");
    public static final FactoryParameterKey EMBEDDED = new FactoryParameterKey("embedded");
    static /* synthetic */ Class class$com$lowagie$text$pdf$BaseFont;

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        ResourceKey key = data.getKey();
        Map factoryParameters = key.getFactoryParameters();
        boolean embedded = Boolean.TRUE.equals(factoryParameters.get(EMBEDDED));
        String encoding = String.valueOf(factoryParameters.get(ENCODING));
        String fontType = String.valueOf(factoryParameters.get(FONTNAME));
        DependencyCollector dc = new DependencyCollector(key, data.getVersion(manager));
        byte[] ttfAfm = data.getResource(manager);
        byte[] pfb = null;
        if (embedded && (fontType.endsWith(".afm") || fontType.endsWith(".pfm"))) {
            String pfbFileName = fontType.substring(0, fontType.length() - 4) + ".pfb";
            try {
                ResourceKey pfbKey = manager.deriveKey(key, pfbFileName);
                ResourceData res = manager.load(pfbKey);
                pfb = res.getResource(manager);
                dc.add(pfbKey, res.getVersion(manager));
            }
            catch (ResourceException e) {
                // empty catch block
            }
        }
        try {
            Log.debug((Object)("Created font " + fontType));
            BaseFont baseFont = BaseFont.createFont((String)fontType, (String)encoding, (boolean)embedded, (boolean)false, (byte[])ttfAfm, pfb);
            return new CompoundResource(key, dc, (Object)baseFont);
        }
        catch (Exception e) {
            throw new ResourceCreationException("Failed to create the font " + fontType, e);
        }
    }

    public Class getFactoryType() {
        return class$com$lowagie$text$pdf$BaseFont == null ? (class$com$lowagie$text$pdf$BaseFont = BaseFontResourceFactory.class$("com.lowagie.text.pdf.BaseFont")) : class$com$lowagie$text$pdf$BaseFont;
    }

    public void initializeDefaults() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

