/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.pdf.itext;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.registry.FontSource;
import org.jfree.fonts.truetype.TrueTypeFontRecord;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.modules.output.pdf.itext.BaseFontCreateException;
import org.jfree.layouting.modules.output.pdf.itext.BaseFontFactory;
import org.jfree.layouting.modules.output.pdf.itext.BaseFontRecord;
import org.jfree.layouting.modules.output.pdf.itext.BaseFontRecordKey;
import org.jfree.layouting.modules.output.pdf.itext.BaseFontResourceFactory;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.Log;
import org.jfree.util.StringUtils;

public class BaseFontSupport
implements FontMapper {
    private static ResourceManager resourceManager;
    private final Map baseFonts = new HashMap();
    private String defaultEncoding;
    private boolean useGlobalCache;
    private boolean embedFonts;
    private BaseFontFactory baseFontFactory;

    protected static synchronized ResourceManager getResourceManager() {
        if (resourceManager == null) {
            resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            resourceManager.registerFactory((ResourceFactory)new BaseFontResourceFactory());
        }
        return resourceManager;
    }

    public BaseFontSupport() {
        this("Identity-H");
    }

    public BaseFontSupport(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        ExtendedConfiguration extendedConfig = LibLayoutBoot.getInstance().getExtendedConfig();
        this.useGlobalCache = extendedConfig.getBoolProperty("org.jfree.layouting.modules.output.pdf.itext.UseGlobalFontCache");
        this.baseFontFactory = new BaseFontFactory();
        this.baseFontFactory.registerDefaultFontPath(defaultEncoding);
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        if (defaultEncoding == null) {
            throw new NullPointerException("DefaultEncoding is null.");
        }
        this.defaultEncoding = defaultEncoding;
    }

    public boolean isEmbedFonts() {
        return this.embedFonts;
    }

    public void setEmbedFonts(boolean embedFonts) {
        this.embedFonts = embedFonts;
    }

    public void close() {
        this.baseFonts.clear();
    }

    public BaseFontRecord createBaseFont(String logicalName, boolean bold, boolean italic, String encoding, boolean embedded) throws BaseFontCreateException {
        String stringEncoding;
        String fontKey;
        block23: {
            boolean builtInFont;
            if (logicalName == null) {
                throw new NullPointerException("Font definition is null.");
            }
            if (encoding == null) {
                throw new NullPointerException("Encoding is null");
            }
            if (this.isCourier(logicalName)) {
                fontKey = this.createCourierName(bold, italic);
                builtInFont = true;
            } else if (this.isSerif(logicalName)) {
                fontKey = this.createSerifName(bold, italic);
                builtInFont = true;
            } else if (this.isSansSerif(logicalName)) {
                fontKey = this.createSansSerifName(bold, italic);
                builtInFont = true;
            } else {
                fontKey = logicalName;
                builtInFont = false;
            }
            stringEncoding = encoding;
            if (encoding.equalsIgnoreCase("Identity-H") || encoding.equalsIgnoreCase("Identity-V")) {
                stringEncoding = "utf-8";
            }
            try {
                FontRecord registryFontRecord = this.baseFontFactory.getFontForName(fontKey, bold, italic);
                if (registryFontRecord != null && !builtInFont) {
                    BaseFontRecord fontRecord;
                    FontSource source;
                    boolean embeddedOverride = embedded;
                    if (embedded && registryFontRecord instanceof FontSource && !(source = (FontSource)registryFontRecord).isEmbeddable()) {
                        Log.warn((Object)("License of font forbids embedded usage for font: " + fontKey));
                        embeddedOverride = false;
                    }
                    if ((fontRecord = this.createFontFromTTF(registryFontRecord, bold, italic, encoding, stringEncoding, embeddedOverride)) != null) {
                        return fontRecord;
                    }
                } else {
                    BaseFontRecord fontRecord = this.getFromCache(fontKey, encoding, embedded);
                    if (fontRecord != null) {
                        return fontRecord;
                    }
                    fontRecord = this.getFromCache(fontKey, stringEncoding, embedded);
                    if (fontRecord != null) {
                        return fontRecord;
                    }
                    BaseFont f = BaseFont.createFont((String)fontKey, (String)stringEncoding, (boolean)embedded, (boolean)this.useGlobalCache, null, null);
                    if (f != null) {
                        fontRecord = new BaseFontRecord(fontKey, false, embedded, f, bold, italic);
                        this.putToCache(fontRecord);
                        return fontRecord;
                    }
                }
            }
            catch (Exception e) {
                if (Log.isDebugEnabled()) {
                    Log.debug((Object)new Log.SimpleMessage("BaseFont.createFont failed. Key = ", (Object)fontKey, (Object)": ", (Object)e.getMessage()), (Exception)e);
                }
                if (!Log.isWarningEnabled()) break block23;
                Log.warn((Object)new Log.SimpleMessage("BaseFont.createFont failed. Key = ", (Object)fontKey, (Object)": ", (Object)e.getMessage()));
            }
        }
        try {
            BaseFontRecord fontRecord = this.getFromCache("Helvetica", stringEncoding, embedded);
            if (fontRecord != null) {
                this.putToCache(new BaseFontRecordKey(fontKey, encoding, embedded), fontRecord);
                return fontRecord;
            }
            BaseFont f = BaseFont.createFont((String)"Helvetica", (String)stringEncoding, (boolean)embedded, (boolean)this.useGlobalCache, null, null);
            if (f != null) {
                fontRecord = new BaseFontRecord("Helvetica", false, embedded, f, bold, italic);
                this.putToCache(fontRecord);
                this.putToCache(new BaseFontRecordKey(fontKey, encoding, embedded), fontRecord);
                return fontRecord;
            }
        }
        catch (Exception e) {
            Log.warn((Object)"BaseFont.createFont for FALLBACK failed.", (Exception)e);
            throw new BaseFontCreateException("Null font = " + fontKey);
        }
        throw new BaseFontCreateException("BaseFont creation failed, null font: " + fontKey);
    }

    private BaseFontRecord createFontFromTTF(FontRecord fontRecord, boolean bold, boolean italic, String encoding, String stringEncoding, boolean embedded) throws DocumentException {
        BaseFont f;
        String rawFilename;
        if (fontRecord instanceof TrueTypeFontRecord) {
            TrueTypeFontRecord ttfRecord = (TrueTypeFontRecord)fontRecord;
            rawFilename = ttfRecord.getCollectionIndex() >= 0 ? ttfRecord.getFontFile() + "," + ttfRecord.getCollectionIndex() : ttfRecord.getFontFile();
        } else if (fontRecord instanceof FontSource) {
            FontSource source = (FontSource)fontRecord;
            rawFilename = source.getFontFile();
        } else {
            return null;
        }
        String filename = !fontRecord.isBold() && bold && !fontRecord.isItalic() && italic ? rawFilename + ",BoldItalic" : (!fontRecord.isBold() && bold ? rawFilename + ",Bold" : (!fontRecord.isItalic() && italic ? rawFilename + ",Italic" : rawFilename));
        BaseFontRecord fontRec = this.getFromCache(filename, encoding, embedded);
        if (fontRec != null) {
            return fontRec;
        }
        try {
            try {
                f = BaseFont.createFont((String)filename, (String)encoding, (boolean)embedded, (boolean)false, null, null);
            }
            catch (DocumentException e) {
                f = BaseFont.createFont((String)filename, (String)stringEncoding, (boolean)embedded, (boolean)false, null, null);
            }
        }
        catch (IOException ioe) {
            throw new DocumentException("Failed to read the font: " + ioe);
        }
        BaseFontRecord record = new BaseFontRecord(filename, true, embedded, f, fontRecord.isBold(), fontRecord.isItalic());
        this.putToCache(record);
        return record;
    }

    private void putToCache(BaseFontRecord record) {
        BaseFontRecordKey key = record.createKey();
        this.putToCache(key, record);
    }

    private void putToCache(BaseFontRecordKey key, BaseFontRecord record) {
        this.baseFonts.put(key, record);
    }

    private BaseFontRecord getFromCache(String fileName, String encoding, boolean embedded) {
        BaseFontRecordKey key = new BaseFontRecordKey(fileName, encoding, embedded);
        BaseFontRecord r = (BaseFontRecord)this.baseFonts.get(key);
        if (r != null) {
            return r;
        }
        return null;
    }

    private String createSansSerifName(boolean bold, boolean italic) {
        if (bold && italic) {
            return "Helvetica-BoldOblique";
        }
        if (bold) {
            return "Helvetica-Bold";
        }
        if (italic) {
            return "Helvetica-Oblique";
        }
        return "Helvetica";
    }

    private String createSerifName(boolean bold, boolean italic) {
        if (bold && italic) {
            return "Times-BoldItalic";
        }
        if (bold) {
            return "Times-Bold";
        }
        if (italic) {
            return "Times-Italic";
        }
        return "Times-Roman";
    }

    private String createCourierName(boolean bold, boolean italic) {
        if (bold && italic) {
            return "Courier-BoldOblique";
        }
        if (bold) {
            return "Courier-Bold";
        }
        if (italic) {
            return "Courier-Oblique";
        }
        return "Courier";
    }

    public BaseFont awtToPdf(Font font) {
        boolean embed = this.isEmbedFonts();
        String encoding = this.getDefaultEncoding();
        try {
            BaseFontRecord record = this.createBaseFont(font.getName(), font.isBold(), font.isItalic(), encoding, embed);
            return record.getBaseFont();
        }
        catch (Exception e) {
            throw new BaseFontCreateException("Unable to create font: " + font, e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String logicalName = this.getFontName(font);
        int style = StringUtils.endsWithIgnoreCase((String)logicalName, (String)"bolditalic") ? 3 : (StringUtils.endsWithIgnoreCase((String)logicalName, (String)"bold") ? 1 : (StringUtils.endsWithIgnoreCase((String)logicalName, (String)"italic") ? 2 : 0));
        return new Font(logicalName, style, size);
    }

    private String getFontName(BaseFont font) {
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return names[0][3];
        }
        String nameExtr = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if ("1".equals(name[0]) && "0".equals(name[1])) {
                nameExtr = name[3];
                continue;
            }
            if (!"1033".equals(name[2])) continue;
            nameExtr = name[3];
            break;
        }
        if (nameExtr != null) {
            return nameExtr;
        }
        return names[0][3];
    }

    public boolean isSansSerif(String fontName) {
        return StringUtils.startsWithIgnoreCase((String)fontName, (String)"SansSerif") || StringUtils.startsWithIgnoreCase((String)fontName, (String)"Dialog") || StringUtils.startsWithIgnoreCase((String)fontName, (String)"SanSerif");
    }

    public boolean isCourier(String fontName) {
        return StringUtils.startsWithIgnoreCase((String)fontName, (String)"dialoginput") || StringUtils.startsWithIgnoreCase((String)fontName, (String)"monospaced");
    }

    public boolean isSerif(String fontName) {
        return StringUtils.startsWithIgnoreCase((String)fontName, (String)"serif");
    }
}

